require 'runit/testcase'

require 'kagemai/bts'

class TestBTS < RUNIT::TestCase
  def setup()
    Kagemai::MessageBundle.open('resource', 'ja', 'messages')
    @base_dir = 'test/testfile/projects'
    @bts = Kagemai::BTS.new(@base_dir)

    @default_store = Kagemai::BTS::DEFAULT_DB_MANAGER_CLASS
  end

  def teardown()
  end

  def test_open_project()
    project = @bts.open_project('p1')
    assert_instance_of(Kagemai::Project, project)
  end

  def test_each_project()
    expect = ['p1', 'p2']
    result = []
    @bts.each_project do |project|
      result.push(project.id)
    end
    assert_equals(expect, result)
  end

  def test_exist_project?()
    assert_equals(true, @bts.exist_project?('p1'))
    assert_equals(false, @bts.exist_project?('p3'))
  end
  
  def test_convert_store1()
    begin
      require 'dbi/dbi'
      require 'kagemai/pgstore'
    rescue LoadError
      return
    end
    
    id = '_filestore_test'
    expect_id = '_filestore_expect'
    id_path = "#{@base_dir}/#{id}"
    expect_path = "#{@base_dir}/#{expect_id}"
    begin
      system("cp -pr #{expect_path} #{id_path}")
      
      store = Kagemai::FileStore
      project = @bts.open_project(id)
      
      conv_store = Kagemai::PostgresStore
      
      @bts.convert_store(id, project.charset, project.report_type, store, conv_store)
      @bts.convert_store(id, project.charset, project.report_type, conv_store, store)
      system("rm -f #{id_path}/cache*")
      assert_equals('', diff_dirs(id, expect_id))
    ensure
      system("rm -r #{id_path}")
    end
  end

  private
  def diff_dirs(id1, id2)
    dir1 = "#{@base_dir}/#{id1}"
    dir2 = "#{@base_dir}/#{id2}"
    IO.popen("diff -r #{dir1} #{dir2}") do |output|
      # ignore CVS directories
      output.read.gsub(/^.*CVS$/, '').strip
    end
  end

end

