require 'runit/testcase'
require 'kagemai/element'
require 'kagemai/elementtype'
require 'kagemai/message_bundle'

class TestElement < RUNIT::TestCase
  def setup
    Kagemai::MessageBundle.open('resource', 'ja', 'messages')
    @eid = 'email'
    @etype = Kagemai::ElementType.new({'id' => @eid, 'name' => 'email address'})
  end

  def test_new()
    element = Kagemai::Element.new(@etype, nil)
    assert_instance_of(Kagemai::Element, element)
    assert_equals(@etype, element.type)
    assert_equals(@eid, element.id)
    assert_nil(element.value)
  end

  def test_new2()
    value = 'value'
    element = Kagemai::Element.new(@etype, nil, value)
    assert_equals(@eid, element.id)
    assert_equals(value, value)
  end

  def test_value=()
    element = Kagemai::Element.new(@etype, nil)
    assert_nil(element.value)
    value = 'v of bar'
    element.value = value
    assert_equals(value, element.value)
  end
end

