require 'runit/testcase'

require 'kagemai/pmutex'

class TestPMutex < RUNIT::TestCase
  include Kagemai

  def setup
    @filename = 'test/testfile/p_mutex_lock'
    File.open(@filename, 'w') {|file| }
    
    @mutex = PMutex.new(@filename)
    @mutex2 = PMutex.new(@filename)
  end
  
  def teardown
    File.unlink(@filename)
  end

  # test use same mutex.
  def test_sync
    r1 = nil
    r2 = nil
    
    count = 1
    
    t1 = Thread.start {
      @mutex.synchronize {
        Thread.pass
        r1 = count
        count += 1
      }
    }
    
    t2 = Thread.start {
      @mutex.synchronize {
        r2 = count
        count += 1
      }
    }
    
    t1.join
    t2.join
    
    assert_equals(1, r1)
    assert_equals(2, r2)
  end
  
  # test use different mutex.
  def test_sync2
    r1 = nil
    r2 = nil
    
    count = 1
    
    t1 = Thread.start {
      @mutex.synchronize {
        Thread.pass
        r1 = count
        count += 1
      }
    }
    
    t2 = Thread.start {
      @mutex2.synchronize {
        r2 = count
        count += 1
      }
    }
    
    t1.join
    t2.join
    
    assert_equals(1, r1)
    assert_equals(2, r2)
  end

end
