require 'runit/testcase'
require 'kagemai/reporttype'
require 'kagemai/message_bundle'

class String
  def id
    self
  end

  def use_cookie?() false; end
  def use_cache?() false; end
end

class TestReportType < RUNIT::TestCase
  def setup
    Kagemai::MessageBundle.open('resource', 'ja', 'messages')
    @rtype = Kagemai::ReportType.new

    @etypes = ['e1', 'e2', 'e3']
    @etypes.each do |e|
      @rtype.add_element_type(e)
    end
  end

  def test_new
    assert_instance_of(Kagemai::ReportType, @rtype)
  end

  def test_each
    result = Array.new
    @rtype.each do |e|
      result.push(e)
    end
    assert_equals(@etypes, result)
  end

  def test_assoc
    assert_equals('e1', @rtype['e1'])
  end

  def test_load
    xmlfile = 'test/testfile/rtype0.xml'
    Kagemai::ReportType.module_eval('include Enumerable')

    rtype = Kagemai::ReportType.load(xmlfile)
    assert_instance_of(Kagemai::ReportType, rtype)

    # ԤǤ
    email = Kagemai::StringElementType.new({'id' => 'email', 'name' => ''})
    email.description = 'ԤΥ᡼륢ɥ쥹ϤƤ'
    status = Kagemai::SelectElementType.new({'id' => 'status', 'name' => '', 'default' => ''})
    status.add_choice(Kagemai::SelectElementType::Choice.new({'id' => ''}))
    status.add_choice(Kagemai::SelectElementType::Choice.new({'id' => '̤'}))
    status.add_choice(Kagemai::SelectElementType::Choice.new({'id' => 'Ѥ'}))
    status.add_choice(Kagemai::SelectElementType::Choice.new({'id' => 'λ'}))
    message = Kagemai::TextElementType.new({'id' => 'message', 'name' => ''})
    message.description = 'ʷ顦Ƥˤɤ;ʬʰѤ䰧Ϥޤ'
    cookie = Kagemai::BooleanElementType.new({'id' => 'cookie', 'name' => '᡼륢ɥ쥹¸', 'default' => 'true'})
    cookie.description = 'åѤƥ᡼륢ɥ쥹¸롣'

    expect_etypes = [email, status, message, cookie]
    etypes = rtype.to_a
    (0..(expect_etypes.size - 1)).each do |i|
      assert_equals(expect_etypes[i], etypes[i])
    end
  end
end

