require 'runit/testcase'
require 'kagemai/message'
require 'kagemai/reporttype'
require 'kagemai/elementtype'
require 'kagemai/message_bundle'

require 'kagemai/xmlstore'

include Kagemai

class TestXMLStore < RUNIT::TestCase
  def setup
    Kagemai::MessageBundle.open('resource', 'ja', 'messages')
    @dir = 'test/testfile'
    @report_type = ReportType.load('test/testfile/rtype0.xml')

    @email = ['fukouka@daifukuya.com', 'tomoyuki@daifukuya.com']
    @body = ['hell world', 'hello dbi']
    @opt = [{'o1' => 'v1', 'o2' => true}, {'o3' => false}]

    @messages = []
    0.upto(1) do |i|
      msg = Message.new(@report_type) 
      msg['email'] = @email[i] 
      msg['message'] = @body[i]
      @opt[i].each{|k, v| msg.set_option(k, v)}
      @messages << msg
    end

    begin
      FileStore.create(@dir, nil, @report_type, 'EUC-JP')
      @store = XMLFileStore.new(@dir, nil, @report_type, 'EUC-JP')
      @store.disable_cache
    rescue Exception
      FileStore.destroy(@dir, nil)
      raise
    end
  end

  def teardown
    FileStore.destroy(@dir, nil)
  end

  def test_store()
    report = nil
    report_id = nil
      
    message = @messages[0].dup
    @store.transaction {
      report_id = @store.next_id
      report = Report.new(@report_type, report_id)
      report.add_message(@messages[0])
      report.add_message(@messages[1])
      @store.store(report)
    }

    lreport = @store.load(@report_type, report_id)
    assert_instance_of(Kagemai::Report, lreport)
    assert_equals(2, lreport.size)
    assert_equals(@email[0], lreport.first['email'])
    assert_equals(@body[0], lreport.first['message'])
    assert_equals(@email[1], lreport.last['email'])
    assert_equals(@body[1], lreport.last['message'])
  end


  def test_update()
    report = nil
    report_id = nil
      
    message = @messages[0].dup
    @store.transaction {
      report_id = @store.next_id
      report = Report.new(@report_type, report_id)
      report.add_message(@messages[0])
      report.add_message(@messages[1])
      @store.store(report)
    }
    assert_equals(@email[1], report.last['email'])

    new_email = 'kagemai_test@daifukuya.com'
    report.last['email'] = new_email
    report.last.modified = true
    @store.transaction {
      @store.update(report)
    }

    lreport = @store.load(@report_type, report_id)
    assert_equals(new_email, lreport.last['email'])
  end

  def test_update2()
    report = nil
    report_id = nil
      
    message = @messages[0].dup
    @store.transaction {
      report_id = @store.next_id
      report = Report.new(@report_type, report_id)
      report.add_message(@messages[0])
      report.add_message(@messages[1])
      @store.store(report)
    }
    lreport = @store.load(@report_type, report_id)
    assert_equals(2, lreport.size)
    assert_equals(@email[1], lreport.last['email'])

    @store.transaction {
      report = Report.new(@report_type, report_id)
      report.add_message(@messages[0])
      @store.update(report)
    }
    lreport = @store.load(@report_type, report_id)
    assert_equals(1, lreport.size)
    assert_equals(@email[0], lreport.last['email'])
  end
end
