#!/usr/bin/ruby -wKe
require 'runit/testcase'
require 'runit/cui/testrunner'

BEGIN { $defout.binmode }
$KCODE = 'e'
$SAFE = 1

$WIN32 = (RUBY_PLATFORM =~ /mswin32|cygwin/) != nil
$:.push("./lib");

kagemai_root = "."

require 'kagemai/config'
Kagemai::Config.initialize(kagemai_root, nil)

test_all = ARGV.size == 0
Dir.glob("test/[A-z]*_test.rb").each do |test_script|
  /test\/(.+)\.rb/ =~ test_script
  basename = $1
  if test_all or ARGV.include?(basename)
    puts 'load test script: ' + test_script
    require test_script.untaint
  end
end

suite = RUNIT::TestSuite.new
ObjectSpace.each_object(Class) {|class_obj|
  if class_obj.ancestors.include?(RUNIT::TestCase)
    suite.add_test(class_obj.suite)
  end
}

require 'kagemai/logger'
if $DEBUG then
  Kagemai::Logger.level = Kagemai::Logger::DEBUG

  #Kagemai::Logger.add_category('Project')
  #Kagemai::Logger.add_category('ReportType')
  Kagemai::Logger.add_category('DBI')
  Kagemai::Logger.add_category('Temp')
end

RUNIT::CUI::TestRunner.quiet_mode = false
RUNIT::CUI::TestRunner.run(suite)

if $DEBUG then
  puts Kagemai::Logger.buffer()
end
