require 'runit/testcase'

require 'kagemai/reporttype'
require 'kagemai/report'
require 'kagemai/message'

do_mysql_test = false
begin
  require 'mysql'
  require 'kagemai/mysqlstore'
  do_mysql_test = true
rescue LoadError
end

if do_mysql_test && Kagemai::Config[:enable_mysql] then
  include Kagemai

  class TestMySQLStoreAttach < RUNIT::TestCase
    def setup()
      Kagemai::MessageBundle.open('resource', 'ja', 'messages')
      
      @project_id = 'kagemai_unittest'
      @report_type = ReportType.load('test/testfile/rtype2.xml')
      @charset = 'EUC-JP'
      
      MySQLStore.create(nil, @project_id, @report_type, @charset)
      @store = MySQLStore.new(nil, @project_id, @report_type, @charset)
    end
    
    def teardown()
      sleep(1)
      MySQLStore.destroy(nil, @project_id)
      sleep(2)
    end
    
    def test_store_attachment()
      original_filename = 'test/testfile/mail/mail1.txt'
      
      attachment = File.open(original_filename, 'rb')
      expect = attachment.read
      attachment.rewind
      
      eval <<-EVAL_END
      class << attachment
        def original_filename()
          '#{original_filename}'
        end
      end
      EVAL_END
      
      oid = @store.store_attachment(attachment)
      assert_not_nil(oid)
        
      file = @store.open_attachment(oid)
      
      assert_equals(expect.inspect, file.read.inspect)
    end

    def test_store_attachment_bin()
      original_filename = 'test/testfile/sample.gif'
      
      attachment = File.open(original_filename, 'rb')
      expect = attachment.read
      attachment.rewind
      
      eval <<-EVAL_END
      class << attachment
        def original_filename()
          '#{original_filename}'
        end
      end
      EVAL_END
      
      oid = @store.store_attachment(attachment)
      assert_not_nil(oid)
        
      file = @store.open_attachment(oid)
      
      assert_equals(expect.inspect, file.read.inspect)
    end
    
  end
end
