require 'runit/testcase'

require 'kagemai/reporttype'
require 'kagemai/report'
require 'kagemai/message'

do_pg_test = false
begin
  require 'postgres'
  require 'kagemai/pgstore'
  do_pg_test = true
rescue LoadError
end

if do_pg_test && Kagemai::Config[:enable_postgres] then
  include Kagemai

  class TestPostgresStoreAttach < RUNIT::TestCase
    def setup()
      Kagemai::MessageBundle.open('resource', 'ja', 'messages')
      
      @project_id = 'kagemai_unittest'
      @report_type = ReportType.load('test/testfile/rtype2.xml')
      @charset = 'EUC-JP'
      
      PostgresStore.create(nil, @project_id, @report_type, @charset)
      @store = PostgresStore.new(nil, @project_id, @report_type, @charset)
    end
    
    def teardown()
      sleep(1)
      PostgresStore.destroy(nil, @project_id)
      sleep(2)
    end
    
    def test_store_attachment()
      original_filename = 'test/testfile/mail/mail1.txt'
      
      attachment = File.open(original_filename)
      expect = attachment.read
      
      eval <<-EVAL_END
      class << attachment
        def original_filename()
          '#{original_filename}'
        end
      end
      EVAL_END
      
      oid = @store.store_attachment(attachment)
      assert_not_nil(oid)
        
      file = @store.open_attachment(oid)
      
      assert_equals(expect, file.read)
    end
    
  end
end
