﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Kakuretter
{
    public partial class Form3 : Form
    {

        private bool FormLoadCheckedEventCancel = true;

        private Properties.Settings settings;

        public Form3()
        {
            InitializeComponent();
            this.settings = Properties.Settings.Default;
        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void trackBar1_Scroll(object sender, EventArgs e)
        {

        }

        private void Form3_Load(object sender, EventArgs e)
        {
            // 最小値、最大値を設定
            trackBar1.Minimum = 0;
            trackBar1.Maximum = 100;

            // 初期値を設定
            this.trackBar1.Value = 100 - (int)(this.settings.Opacity * 100);

            // 描画される目盛りの刻みを設定
            trackBar1.TickFrequency = 10;

            // スライダーをキーボードやマウス、
            // PageUp,Downキーで動かした場合の移動量設定
            trackBar1.SmallChange = 1;
            trackBar1.LargeChange = 10;

            // 値が変更された際のイベントハンドラーを追加
            trackBar1.ValueChanged += new EventHandler(trackBar1_ValueChanged);

            checkBox1.Checked = this.settings.ReplyPopup;
            numericUpDown1.Value = this.settings.ReplyInterval / 60000;
            if (this.settings.HotKeyHidden == true)
            {
                checkBox2.Checked = this.settings.HotKeyHidden;
            }
            else
            {
                checkBox2.Checked = this.settings.HotKeyHidden;
                FormLoadCheckedEventCancel = false;
            }

            

        }

        void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            // TrackBarの値が変更されたらラベルに表示
            var tb1 = trackBar1.Value;
            tb1 = 100 - tb1;
            Form1.Form1Instance.Opacity = (0.1 * 0.1 * tb1);
            this.settings.Opacity = (0.1 * 0.1 * tb1);

            this.settings.Save();
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            Form1.Form1Instance.timer1.Enabled = checkBox1.Checked;
            this.settings.ReplyPopup = checkBox1.Checked;
            this.settings.Save();
        }

        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
            int interval = (int)numericUpDown1.Value * 60000;
            Form1.Form1Instance.timer1.Interval = interval;
            this.settings.ReplyInterval = interval;
            this.settings.Save();
        }

        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            if (this.FormLoadCheckedEventCancel == false)
            {
                if (checkBox2.Checked == true)
                {
                    Form1.Form1Instance.HotKeyHiddenActivate();
                }
                else
                {
                    Form1.Form1Instance.hotKey.Dispose();
                }
                this.settings.HotKeyHidden = checkBox2.Checked;
                this.settings.Save();
            }
            else
            {
                this.FormLoadCheckedEventCancel = false;
            }
        }

    }
}
