﻿using System;
using System.ComponentModel;
using System.Reflection;

namespace Kasuga
{
    public class FormatPropertyDescriptor : PropertyDescriptor
    {
        public FormatPropertyDescriptor(PropertyDescriptor descriptor)
            : base(descriptor)
        {
            try
            {
                _descriptor = descriptor;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        private PropertyDescriptor _descriptor;

        public override object GetValue(object component)
        {
            try
            {
                IHasFormatDictionary element = (IHasFormatDictionary)component;
                return element.FormatDictionary[_descriptor.Name];
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public override void SetValue(object component, object value)
        {
            try
            {
                IHasFormatDictionary element = (IHasFormatDictionary)component;
                element.SetFormatProperty(_descriptor.Name, value, true);
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public override bool CanResetValue(object component)
        {
            try
            {
                IHasFormatDictionary element = (IHasFormatDictionary)component;
                return element.BaseFormat != null;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override void ResetValue(object component)
        {
            try
            {
                IHasFormatDictionary element = (IHasFormatDictionary)component;
                IFormat baseFormat = element.BaseFormat;
                if (baseFormat != null)
                {
                    PropertyDescriptorCollection descriptors = TypeDescriptor.GetProperties(baseFormat);
                    PropertyDescriptor descriptor = descriptors.Find(_descriptor.Name, true);
                    SetValue(component, descriptor.GetValue(baseFormat));
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public override bool ShouldSerializeValue(object component)
        {
            try
            {
                IHasFormatDictionary element = (IHasFormatDictionary)component;
                IFormat baseFormat = element.BaseFormat;
                if (baseFormat == null)
                {
                    return true;
                }
                else
                {
                    PropertyDescriptorCollection descriptors = TypeDescriptor.GetProperties(baseFormat);
                    PropertyDescriptor descriptor = descriptors.Find(_descriptor.Name, true);
                    return !descriptor.GetValue(baseFormat).Equals(GetValue(component));
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }

        public override Type ComponentType
        {
            get
            {
                try
                {
                    return typeof(IHasFormatDictionary);
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }

        public override bool IsReadOnly
        {
            get
            {
                try
                {
                    return _descriptor.IsReadOnly;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return false;
                }
            }
        }

        public override Type PropertyType
        {
            get
            {
                try
                {
                    return _descriptor.PropertyType;
                }
                catch (Exception exception)
                {
                    Debug.Show(
                        exception,
                        Assembly.GetExecutingAssembly(),
                        MethodBase.GetCurrentMethod());
                    return null;
                }
            }
        }
    }
}
