﻿using System;
using System.Reflection;

namespace Kasuga
{
    public class CatalogItem<T> where T : IPlugin
    {
        public CatalogItem() { }

        public CatalogItem(string name, T plugin)
        {
            try
            {
                Name = name;
                Plugin = plugin;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public string Name { get; set; }
        public T Plugin { get; set; }
    }
}
