﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Reflection;

namespace Kasuga
{
    public class CatalogManager
    {
        static CatalogManager()
        {
            FormatCatalog = new List<CatalogItem<IFormat>>();
            WordArrangementCatalog = new List<CatalogItem<IWordArrangement>>();
            LineArrangementCatalog = new List<CatalogItem<ILineArrangement>>();
            PageArrangementCatalog = new List<CatalogItem<IPageArrangement>>();
        }

        public static List<CatalogItem<IFormat>> FormatCatalog { get; set; }
        public static List<CatalogItem<IWordArrangement>> WordArrangementCatalog { get; set; }
        public static List<CatalogItem<ILineArrangement>> LineArrangementCatalog { get; set; }
        public static List<CatalogItem<IPageArrangement>> PageArrangementCatalog { get; set; }

        public static void AddStaticPlugin<T>(Type type, List<CatalogItem<T>> catalog) where T : IPlugin
        {
            try
            {
                FieldInfo[] fields = type.GetFields();
                foreach (FieldInfo field in fields)
                {
                    if (field.IsStatic && field.FieldType == typeof(CatalogItem<T>))
                    {
                        catalog.Add((CatalogItem<T>)field.GetValue(null));
                    }
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }
    }
}
