﻿#include<sstream>
#include<d3dx9mesh.h>
#include<vector>
#include"../../kernel/device/device_wrapper.h"
#include"../../debugutil/debugconsole.h"
#include"../texture.h"
#include"mesh_object.h"
namespace KFX{

///メッシュロードのD3D実装
class MeshObjectD3D : public KMeshObject{
	private:
		D3DXMATRIXA16 _world;
		KDeviceWrapper& _dev;
		LPD3DXBUFFER _adj;
		LPD3DXBUFFER _materialsBuffer;
		std::vector<D3DMATERIAL9> _materials;
		std::vector<SharedPtr<ITexture>> _textures;
		LPD3DXBUFFER _effectInstances;
		DWORD _materialsNum;
		LPD3DXMESH _mesh;

		//アニメーションメッシュ用
		D3DXFRAME* _frameRoot;
		ID3DXAnimationController* _animController;

		///いちいち_dev.GetDevice()って書きたくないので…
		LPDIRECT3DDEVICE9 Device(){
			return static_cast<LPDIRECT3DDEVICE9>(_dev.GetDevice());
		}
	public:
		MeshObjectD3D();
		~MeshObjectD3D();
		void InitMatrix();
		void RotateX(const float rad);
		void RotateY(const float rad);
		void RotateZ(const float rad);
		void RotateRollYawPitch(const float roll,const float yaw, const float pitch);
		void Move(const Vector3D& vec);
		SharedPtr<ITexture> Texture(const unsigned int idx);
		void LoadFromFile(const wchar_t* );
		void Draw();
		void PostDraw();
		KMeshObject& Mesh();

		///なにもしないメソッド
		void SetFrameIndex(const unsigned int){}
		void AdvanceTime(void){}
		void SetTime(const double){}
};


///メッシュローダ
MeshObjectD3D::MeshObjectD3D():_dev(KDeviceWrapper::Instance()){
	InitMatrix();
}

MeshObjectD3D::~MeshObjectD3D(){
	_mesh->Release();
}

void
MeshObjectD3D::InitMatrix(){
	::D3DXMatrixIdentity(&_world);
}

void 
MeshObjectD3D::RotateX(const float rad){
	D3DXMATRIXA16 world;
	::D3DXMatrixRotationX(&world,rad);
	_world*=world;
}

void 
MeshObjectD3D::RotateY(const float rad){
	D3DXMATRIXA16 world;
	::D3DXMatrixRotationY(&world,rad);
	_world*=world;
}

void 
MeshObjectD3D::RotateZ(const float rad){
	D3DXMATRIXA16 world;
	::D3DXMatrixRotationZ(&world,rad);
	_world*=world;
}

void
MeshObjectD3D::RotateRollYawPitch(const float roll, const float yaw, const float pitch){
	D3DXMATRIXA16 world;
	::D3DXMatrixRotationYawPitchRoll(&world,yaw,pitch,roll);
	_world*=world;
}

VOID
MeshObjectD3D::Move(const Vector3D& vec){
	D3DXMATRIXA16 world;
	::D3DXMatrixTranslation(&world,vec.x,vec.y,vec.z);
	_world*=world;
}

void 
MeshObjectD3D::LoadFromFile(const wchar_t* filename){
	//Direct3Dのメッシュ(アニメーションなしXファイル)を読み込む
	HRESULT result = ::D3DXLoadMeshFromX(filename,
			D3DXMESH_SYSTEMMEM,
			static_cast<LPDIRECT3DDEVICE9>(_dev.GetDevice()),
			&_adj,
			&_materialsBuffer,
			&_effectInstances,
			&_materialsNum,
			&_mesh);

	if( result==D3D_OK ){
		DebugConsole::Instance().Out(L"Succeeded");
		D3DXMATERIAL* materials = static_cast<D3DXMATERIAL*>(_materialsBuffer->GetBufferPointer());
		_materials.resize(_materialsNum);
		_textures.resize(_materialsNum,0);
		
		for(unsigned int idx=0; idx<_materialsNum; ++idx){
			//テクスチャマッピング指定があればそのテクスチャをロード
			if( materials[idx].pTextureFilename ){
				_textures[idx].Reset( ITextureBuilder::Instance().CreateTextureFromFile(materials[idx].pTextureFilename));
			}
			_materials[idx]=materials[idx].MatD3D;
			_materials[idx].Ambient=_materials[idx].Diffuse;
		}
		_materialsBuffer->Release();
	}else{
		switch(result){
			case D3DERR_INVALIDCALL:
				DebugConsole::Instance().Out(L"メソッドの呼び出しが無効です。たとえば、メソッドのパラメータに無効な値が設定されている場合などです。");
				break;
			case E_OUTOFMEMORY :
				DebugConsole::Instance().Out(L"Microsoft Direct3D が呼び出しを完了するための十分なメモリを割り当てることができませんでした。");
				break;
			default:
				DebugConsole::Instance().Out(L"その他エラー");
				std::wostringstream str;
				str << result;
				DebugConsole::Instance().Out(str.str().c_str());
		}
	}
}

KFX::SharedPtr<ITexture>
MeshObjectD3D::Texture(const unsigned int idx){
	if( idx>=_textures.size() ){
		return 0;
	}
	return _textures[idx];
}

void 
MeshObjectD3D::Draw(){
	LPDIRECT3DDEVICE9 dev = Device();
	dev->SetTransform(D3DTS_WORLD,&_world);
	//実はZバッファを使ってしまうとアルファのあるオブジェクトの後ろにあるオブジェクトまでも
	//描画されない。つまり現状アルファブレンディングが行われないということになっている。
	//ただし、それほど簡単な問題でもないので、いまは保留にしておくことにする。
	for(unsigned int i=0; i<_materials.size(); ++i ){
		dev->SetTexture(0,NULL);
		dev->SetMaterial(&_materials[i]);
		if(!!_textures[i]){
			_textures[i]->Apply(0);
		}
		if(_materials[i].Diffuse.a!=1.f){
			dev->SetRenderState(D3DRS_SRCBLEND, 
				D3DBLEND_SRCCOLOR);
			dev->SetRenderState(D3DRS_DESTBLEND, 
							D3DBLEND_INVDESTCOLOR);
		}
		_mesh->DrawSubset(i);		
		dev->SetRenderState(D3DRS_SRCBLEND, 
					D3DBLEND_ONE);
		dev->SetRenderState(D3DRS_DESTBLEND, 
						D3DBLEND_ZERO);
	}
}

void
MeshObjectD3D::PostDraw(){
}

KMeshObjectProvider&
KMeshObjectProvider::Instance(){
	static KMeshObjectProvider instance;
	return instance;
}

KMeshObject*
KMeshObjectProvider::Create(){
	return new MeshObjectD3D();
}

}//end of namespace KFX