﻿#ifndef KFX_MESH_OBJECT_H_INCLUDED
#define KFX_MESH_OBJECT_H_INCLUDED

#include"../Geometory/geometory.h"
#include"../texture.h"
#include"../../kernel/Pointer/shared_ptr.h"
namespace KFX{

///メッシュオブジェクト
///@todo 将来的にはCOLLADAにも対応したい(ファイル拡張子で対応を切り替えたりするか？)
class KMeshObject{
	private:
	public:
		KMeshObject(){}
		virtual ~KMeshObject(){}

		///行列の初期化
		virtual void InitMatrix()=0;

		///かんたんX軸回転メソッド
		///@param rad 回転ラジアン
		virtual void RotateX(const float rad)=0;
		
		///かんたんY軸回転メソッド
		///@param rad 回転ラジアン
		virtual void RotateY(const float rad)=0;
		
		///かんたんZ軸回転メソッド
		///@param rad 回転ラジアン
		virtual void RotateZ(const float rad)=0;

		///かんたん移動メソッド
		///@param vec 移動ヴェクタ
		virtual void Move(const Vector3D& vec)=0;

		///かんたんロールヨーピッチメソッド
		///@param roll ロール(ラジアン)
		///@param yaw ヨー(ラジアン)
		///@pitch pitch ピッチ(ラジアン)
		///@note ロールヨーピッチがわからんときは、http://msdn.microsoft.com/ja-jp/academic/cc998621とか
		///見てください
		virtual void RotateRollYawPitch(const float roll,const float yaw, const float pitch)=0;

		
		///メッシュファイルのロード
		virtual void LoadFromFile(const wchar_t* )=0;
		///メッシュファイルの表示
		virtual void Draw()=0;
		virtual void PostDraw()=0;

		///メッシュが持っているテクスチャオブジェクトを返す
		///@param idx メッシュのテクスチャ番号
		///@note アニメーションメッシュ時にはなにも返さない。
		///非アニメーションメッシュの時にのみ、テクスチャオブジェクトへのポインタ(スマポ)を返す。
		virtual SharedPtr<ITexture> Texture(const unsigned int idx=0)=0;

		///フレームインデクスを切り替える
		///@param index 切り替え先インデクス番号
		///@note アニメーションメッシュの時にのみ意味を持つ
		virtual void SetFrameIndex(const unsigned int index)=0;

		///アニメーションを単位時間進める
		///@note アニメーションメッシュのときにのみ意味を持つ
		///非アニメーションメッシュのときは何もしない
		virtual void AdvanceTime()=0;

		///アニメーションがあるとして指定の時間に飛ぶ
		///@param time 飛び先時間
		///@note アニメーションメッシュのときにのみ意味を持つ
		///非アニメーションメッシュのときはなにもしない
		virtual void SetTime(const double time)=0;
};

class KMeshObjectProvider{
	private:
		KMeshObjectProvider(){};
		KMeshObjectProvider(const KMeshObjectProvider& );
		KMeshObjectProvider& operator=(const KMeshObjectProvider& );
	public:
		static KMeshObjectProvider& Instance();
		KMeshObject* Create();
};

}//end of namespace KFX
#endif