﻿#include"game_input.h"
namespace KFX{
///ゲーム入力を管理する
	GameInput::GameInput() : _peripherals(KPeripheralListHolder::Instance().PeriphList()){
	
}
GameInput& GameInput::Instance(){
	static GameInput instance;
	return instance;
}
void 
GameInput::Update(){
	std::vector<SharedPtr<IPeripheral>>::iterator it=_peripherals.begin();
	std::vector<SharedPtr<IPeripheral>>::iterator itEnd=_peripherals.end();
	for(;it!=itEnd;++it){
		if(!(*it)->IsBinded()){
			continue;
		}
		(*it)->CheckInput();
	}
}

unsigned int 
GameInput::PeripheralsNum() const{
	return _peripherals.size();
}

unsigned int 
GameInput::EntriedPeripheralsNum() const{
	return _peripherals.size();
}
void
GameInput::AddListener(int id,KInputListener* listener){
	_peripherals[id]->AddListener(listener);
}
}//end of namespace KFX
