﻿#include<d3d9.h>
#include<d3dx9.h>
#include<ddraw.h>
#include"device_wrapper.h"
#include"../../game/scene/game_node.h"
#include"../../config/game_config.h"
#include"../../debugutil/debugconsole.h"
#include<algorithm>

namespace KFX{
const wchar_t CLASSNAME[]=L"メッシュ";
const wchar_t WINDOWNAME[]=L"メッシュテスト";
KWindow& 
KWindow::Instance(){
	class WindowImplWin32 : public KWindow{
		public:
			static LRESULT CALLBACK WindowProcedure(HWND handle,UINT msg,WPARAM wparam,LPARAM lparam){
				switch(msg){
					case WM_DESTROY:
						PostQuitMessage(0);//正常終了コード
						return 0;
					default:
						;
						
				}
				return ::DefWindowProc(handle,msg,wparam,lparam);
			}
			WindowImplWin32(){
				WNDCLASS w;
				WNDCLASS wndclass=WNDCLASS();
				wndclass.style=CS_HREDRAW | CS_VREDRAW;
				wndclass.hInstance=GetModuleHandle(NULL);
				wndclass.lpfnWndProc=WindowImplWin32::WindowProcedure;
				wndclass.lpszClassName=CLASSNAME;
				wndclass.hbrBackground=HBRUSH(::GetStockObject(WHITE_BRUSH));
				RegisterClass(&wndclass);
				_handle=static_cast<void*>(
					CreateWindowW(CLASSNAME,
					WINDOWNAME,
					WS_OVERLAPPEDWINDOW,
					0,
					0,
					GameConfig::Instance().ScreenWidth(),
					GameConfig::Instance().ScreenHeight(),
					NULL,
					NULL,
					wndclass.hInstance,
					NULL));
				if( _handle==NULL ){
					DebugConsole::Instance().OutputLastError();
				}
			}
	};
	static KWindow* window=new WindowImplWin32();
	return *window;
}

KDeviceWrapper::KDeviceWrapper() : _dev(nullptr),_rootnode(new RootNode()){

}
void
KDeviceWrapper::Update(){
	_rootnode->Update();
}

KDeviceWrapper& 
KDeviceWrapper::Instance(){
	///Direct3D用デバイスクラス
	///機種依存部は基本的に非公開状態なため、関数内クラスとして作る
	///利用者側はこのクラスを知らない(知らなくてもいい)ものとする
	class DeviceWrapperD3D : public KDeviceWrapper{
		private:
			D3DLIGHT9 _light;///<実験用ライト：そのうちライトクラスとして独立させる予定
			LPDIRECT3D9 _d3d;
			LPDIRECT3DDEVICE9 Device(){return static_cast<LPDIRECT3DDEVICE9>(_dev);}
			//
			struct CUSTOMVERTEX
			{
				D3DXVECTOR3 position; // The position
				D3DCOLOR color;    // The color
				FLOAT tu, tv;   // The texture coordinates
			};
		public:
			DeviceWrapperD3D(){
				HWND handle=static_cast<HWND>(KWindow::Instance().Handle());
				_d3d = Direct3DCreate9(D3D_SDK_VERSION);
				D3DDISPLAYMODE mode=D3DDISPLAYMODE();
				_d3d->GetAdapterDisplayMode(D3DADAPTER_DEFAULT,&mode);
				//表示周り初期化パラメータ設定
				//↓について、わかってない人も多いみたいだから説明します。
				//下のように書くと、構造体がデフォルト初期化されます。構造体のデフォルトは0です。
				//ZeroMemoryなんか書くよりスマートでしょ？
				D3DPRESENT_PARAMETERS present=D3DPRESENT_PARAMETERS();
				present.hDeviceWindow=handle;
				present.Windowed = !GameConfig::Instance().IsFullScreen();
				present.SwapEffect=D3DSWAPEFFECT_DISCARD;
				present.EnableAutoDepthStencil=TRUE;
				present.AutoDepthStencilFormat=D3DFMT_D16;
				present.BackBufferCount=1;//バックバッファ使用
				present.BackBufferFormat=mode.Format;
				present.BackBufferWidth=mode.Width;
				present.BackBufferHeight=mode.Height;
				present.MultiSampleType=D3DMULTISAMPLE_NONE;
				
				//例によってDirect3Dデバイス作成
				HRESULT result = _d3d->CreateDevice(D3DADAPTER_DEFAULT,
					D3DDEVTYPE_HAL,
					handle,
					D3DCREATE_SOFTWARE_VERTEXPROCESSING,
					&present,
					(LPDIRECT3DDEVICE9*)&_dev);
				if(D3D_OK==result){
					DebugConsole::Instance().Out(L"CreateDevice OK");
					Init();
				}else{
					switch(result){
						case D3DERR_DEVICELOST:
							DebugConsole::Instance().Out(L"デバイスは、消失していますが、現在リセットできません。したがって、レンダリングは不可能です。");
							break;
						case D3DERR_INVALIDCALL:
							DebugConsole::Instance().Out(L"メソッドの呼び出しが無効です。たとえば、メソッドのパラメータに無効な値が設定されている場合などです。 ");
							break;
						case D3DERR_NOTAVAILABLE:
							DebugConsole::Instance().Out(L"このデバイスは、問い合わせたテクニックをサポートしていません。");
							break;
						case D3DERR_OUTOFVIDEOMEMORY:
							DebugConsole::Instance().Out(L"Direct3Dが処理を行うのに十分なディスプレイ メモリがありません。");
							break;
						default:
							DebugConsole::Instance().Out(L"その他のエラー");
					}
				}

			}
			//ライトの初期化
			void InitLight(){
				_light=D3DLIGHT9();
				_light.Range=1000.f;
				_light.Diffuse.a=1.0f;
				_light.Diffuse.r=1.0f;
				_light.Diffuse.g=1.0f;
				_light.Diffuse.b=1.0f;
				_light.Ambient.a=1.0f;
				_light.Ambient.r=1.0f;
				_light.Ambient.g=1.0f;
				_light.Ambient.b=1.0f;
				_light.Specular.a=1.0f;
				_light.Specular.r=1.0f;
				_light.Specular.g=1.0f;
				_light.Specular.b=1.0f;
				_light.Type=D3DLIGHT_DIRECTIONAL;//とりあえず平行光源
				_light.Position.x=0.f;
				_light.Position.y=0.f;
				_light.Position.z=0.f;
				_light.Direction.x=0.f;
				_light.Direction.y=-1.f;
				_light.Direction.z=0.f;
				Device()->LightEnable(0,TRUE);//セットしたライトを使えるように
				Device()->SetRenderState(D3DRS_LIGHTING,TRUE);
				Device()->SetRenderState(D3DRS_SPECULARENABLE,TRUE);
			}
			//天半球初期化
			void InitHemisphere(){
			//	Direct3D
			}
			//初期化
			void Init(){
				Device()->SetRenderState(D3DRS_ZENABLE,TRUE);
				InitLight();
				//アルファブレンディング設定
				Device()->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
				Device()->SetRenderState(D3DRS_SRCBLEND, 
							    D3DBLEND_SRCALPHA);
				Device()->SetRenderState(D3DRS_DESTBLEND, 
							    D3DBLEND_INVSRCALPHA);
				//環境光設定
				Device()->SetRenderState(D3DRS_AMBIENT,0x00202020);
			}
			///カメラ行列等の設定
			void SetMatrix(){
				//実際このへんはサンプルまんまなので、理解が進んだら変更入れようと思う。
				D3DXMATRIXA16 world;
				D3DXMatrixIdentity(&world);
				D3DXMatrixRotationY(&world,45.f*D3DX_PI/180.f);
				Device()->SetTransform(D3DTS_WORLD,&world);
				D3DXVECTOR3 eyePnt(0.f,0.f,-10.f);//視点
				D3DXVECTOR3 lookatPnt(0.f,0.f,0.f);//注視点
				D3DXVECTOR3 upVector(0.f,1.f,0.f);//上
				D3DXMATRIXA16 viewport;//ビューポートマトリクス
				///いわゆる視錐台設定
				D3DXMatrixLookAtLH(&viewport,
					&eyePnt,
					&lookatPnt,
					&upVector);
				Device()->SetTransform(D3DTS_VIEW,&viewport);
				D3DXMATRIXA16 proj;//透視変換
				D3DXMatrixPerspectiveFovLH(&proj,D3DX_PI/4,
					1.f,
					1.f,
					1000.f);
				Device()->SetTransform(D3DTS_PROJECTION,&proj);
			}

			//毎フレ走る処理
			void Update(){
				//ここでZバッファまでクリアしとかんと、次の描画に影響が出る
				Device()->Clear(0,NULL,D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
					D3DCOLOR_XRGB(0xffffff,0xffffff,0),1.f,0);
				Device()->BeginScene();

				D3DXVECTOR3 vecDir = D3DXVECTOR3( cosf( 0 / 350.0f ),
							0.0f,
							sinf( 0 / 350.0f ) );
				D3DXVec3Normalize( ( D3DXVECTOR3* )&_light.Direction, &vecDir );

				Device()->SetLight(0,&_light);//ライトセット

				SetMatrix();

				KDeviceWrapper::Update();
				LPDIRECT3DSURFACE9 oldsurface;
				Device()->GetRenderTarget(0,&oldsurface);


				Device()->EndScene();
				Device()->Present(NULL,NULL,NULL,NULL);
			}
			bool IsAvailable() const{
				return _dev!=NULL;
			}
			~DeviceWrapperD3D(){
				if( IsAvailable() ){
					Device()->Release();
					_d3d->Release();
				}
			}
	};
	static DeviceWrapperD3D wrapper;
	return wrapper;
}

void* 
KDeviceWrapper::GetDevice() const{
	return _dev;
}

void 
KDeviceWrapper::AddGameNode(GameNode& gamenode){
	_rootnode->AddNode(gamenode);
}

}//end of namespace KFX