/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-history.c 1938 2005-02-15 03:52:38Z ikezoe $
 */

#include "kz-history.h"

#include <glib/gi18n.h>
#include "gobject-utils.h"

static void kz_history_class_init (KzHistoryClass *klass);
static void kz_history_init       (KzHistory      *history);
static void kz_history_dispose    (GObject        *object);

static KzBookmarkFileClass *parent_class = NULL;


KZ_OBJECT_GET_TYPE(kz_history, "KzHistory", KzHistory,
		   kz_history_class_init, kz_history_init,
		   KZ_TYPE_BOOKMARK_FILE)


static void
kz_history_class_init (KzHistoryClass *klass)
{
	GObjectClass *object_class;

	parent_class = g_type_class_peek_parent (klass);
	object_class = (GObjectClass *) klass;

	object_class->dispose      = kz_history_dispose;
#if 0
	object_class->set_property = kz_history_set_property;
	object_class->get_property = kz_history_get_property;
#endif
}


static void
kz_history_init (KzHistory *history)
{
}


static void
kz_history_dispose (GObject *object)
{
	KzHistory *history;

	history = KZ_HISTORY(object);

	if (G_OBJECT_CLASS (parent_class)->dispose)
		G_OBJECT_CLASS (parent_class)->dispose(object);
}


KzHistory *
kz_history_new (const gchar *file)
{
	GObject *obj;
	KzBookmark *bookmark;

	obj = g_object_new(KZ_TYPE_HISTORY,
			   "type",      KZ_BOOKMARK_PURE_FOLDER,
			   "location",  file,
			   "title",     _("History"),
			   "file-type", "XBEL", 
			   NULL);
	bookmark = KZ_BOOKMARK(obj);

	return KZ_HISTORY(bookmark);
}

