/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_BOOKMARK_H__
#define __KZ_BOOKMARK_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK		(kz_bookmark_get_type ())
#define KZ_BOOKMARK(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK, KzBookmark))
#define KZ_BOOKMARK_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_BOOKMARK, KzBookmarkClass))
#define KZ_IS_BOOKMARK(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK))
#define KZ_IS_BOOKMARK_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_BOOKMARK))
#define KZ_BOOKMARK_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_BOOKMARK, KzBookmarkClass))

typedef struct _KzBookmark      KzBookmark;
typedef struct _KzBookmarkClass KzBookmarkClass;

typedef enum
{
	KZ_BOOKMARK_EDITABLE_FLAG    = 1 << 0,
	KZ_BOOKMARK_FOLDER_FLAG      = 1 << 1, /* can have own URI */
	KZ_BOOKMARK_PURE_FOLDER_FLAG = 1 << 2  /* cannot have own URI */
} KzBookmarkFlag;

struct _KzBookmark
{
	GObject        parent;
	KzBookmarkFlag flags;
};

struct _KzBookmarkClass
{
	GObjectClass parent_class;

	void (*children_updated) (KzBookmark *boomark);
};


GType        kz_bookmark_get_type         (void);
KzBookmark  *kz_bookmark_new              (void);
KzBookmark  *kz_bookmark_new_with_attrs   (const gchar *title,
					   const gchar *uri,
					   const gchar *description);
KzBookmark  *kz_bookmark_pure_folder_new  (void);

const gchar *kz_bookmark_get_uri          (KzBookmark  *bookmark);
const gchar *kz_bookmark_get_title        (KzBookmark  *bookmark);
const gchar *kz_bookmark_get_description  (KzBookmark  *bookmark);
guint        kz_bookmark_get_last_modified(KzBookmark  *bookmark);
void         kz_bookmark_set_uri          (KzBookmark  *bookmark,
					   const gchar *uri);
void         kz_bookmark_set_title        (KzBookmark  *bookmark,
					   const gchar *title);
void         kz_bookmark_set_description  (KzBookmark  *bookmark,
					   const gchar *description);
void         kz_bookmark_set_last_modified(KzBookmark  *bookmark,
					   guint        time);

gboolean     kz_bookmark_is_folder        (KzBookmark  *bookmark);
GList       *kz_bookmark_get_children     (KzBookmark  *bookmark);
void         kz_bookmark_set_children     (KzBookmark  *bookmark,
					   GList       *list);

#endif /* __KZ_BOOKMARK_H__ */
