/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <time.h>
#include <gtk/gtk.h>

#include "gobject-utils.h"
#include "utils.h"
#include "intl.h"
#include "kz-google.h"

#define GOOGLE_URI "http://www.google.com/search?lr=lang_ja&hl=ja&ie=UTF-8&oe=utf8&q=%s"

static void  kz_google_class_init        (KzGoogleClass *klass);
static void  kz_google_init              (KzGoogle *google);

static void  kz_google_parse_from_string (KzMETA *meta, gpointer user_data,
					  const gchar *buffer, guint length,
					  GError **error);

static KzMETAClass *parent_class = NULL;

KZ_OBJECT_GET_TYPE(kz_google, "KzGoogle", KzGoogle,
		   kz_google_class_init, kz_google_init,
		   KZ_TYPE_META)

static void
kz_google_class_init (KzGoogleClass *klass)
{
	GObjectClass *object_class;
	KzMETAClass *meta_class;

	parent_class = g_type_class_peek_parent (klass);
	object_class = (GObjectClass *) klass;
	meta_class   = (KzMETAClass *) klass;

	meta_class->kz_meta_parse_from_string = kz_google_parse_from_string;
}


static void
kz_google_init (KzGoogle *google)
{

}


KzGoogle *
kz_google_new (gchar *uri, gchar *title, guint update_interval)
{
	KzGoogle *google = KZ_GOOGLE(g_object_new(KZ_TYPE_GOOGLE,
					 "uri", uri,
					 "title", title,
					 "interval", -1,
					 NULL));
	kz_meta_update((KzMETA*)google);

	return google;
}


static void
kz_google_parse_from_string (KzMETA *meta, gpointer user_data,
			     const gchar *buffer, guint length,
			     GError **error)
{
	gchar *find_pos1, *find_pos2;
	gchar **lines = NULL;
	guint line_number = 0;

	g_return_if_fail(buffer != NULL);
	find_pos1 = strstr(buffer, "<!--m-->");
	if (!find_pos1)
		return;

	lines = g_strsplit(find_pos1 + 8, "<!--m-->", -1);
	while (lines[line_number+1] != NULL)
	{
		KzMETAItem *item;

		item = g_new0(KzMETAItem, 1);
		item->meta = meta;
		
		find_pos1 = strstr(lines[line_number], "<a href=");
		find_pos2  = strstr(lines[line_number], ">");
		if (find_pos1 != NULL && find_pos2 != NULL)
		{
			find_pos1 += 8;
			item->link = g_strndup(find_pos1,
					       find_pos2 - find_pos1);
		}
		else 
			continue;
		find_pos2++;
		find_pos1 = strstr(find_pos2, "</a>"); /* serach </a> */
		if (find_pos1 != NULL)
		{
			item->title = remove_tag(find_pos2, find_pos1 - find_pos2);
			
			find_pos1 += 4;
			item->description = remove_tag(find_pos1, find_pos2 - find_pos1 );
		}
		if (!meta->items)
			meta->items = g_slist_append(meta->items, item);
		else
			g_slist_append(meta->items,item);
		
		line_number++;
	}

	g_strfreev(lines);	
}
