/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_GOOGLE_H__
#define __KZ_GOOGLE_H__

#include <glib-object.h>
#include "kz-meta.h"

G_BEGIN_DECLS

#define KZ_TYPE_GOOGLE		(kz_google_get_type ())
#define KZ_GOOGLE(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_GOOGLE, KzGoogle))
#define KZ_GOOGLE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_GOOGLE, KzGoogleClass))
#define KZ_IS_GOOGLE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_GOOGLE))
#define KZ_IS_GOOGLE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_GOOGLE))
#define KZ_GOOGLE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_GOOGLE, KzGoogleClass))

typedef struct _KzGoogle KzGoogle;
typedef struct _KzGoogleClass KzGoogleClass;

struct _KzGoogle
{
	KzMETA parent;
};

struct _KzGoogleClass
{
	KzMETAClass parent_class;
};

GType     kz_google_get_type (void);
KzGoogle *kz_google_new (gchar *uri, gchar *title, guint update_interval);

G_END_DECLS

#endif /* __KZ_GOOGLE_H__ */
	
