/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <time.h>
#include <gtk/gtk.h>

#include "gobject-utils.h"
#include "intl.h"
#include "kz-hinadi.h"

static void     kz_hinadi_class_init      (KzHINADIClass *klass);
static void     kz_hinadi_init            (KzHINADI *hinadi);
/* static void     kz_hinadi_dispose         (GObject *object); */

static void     kz_hinadi_parse_from_string (KzMETA *meta, gpointer user_data,
					   const gchar *buffer, guint length,
					   GError **error);

static KzMETAClass *parent_class = NULL;

KZ_OBJECT_GET_TYPE(kz_hinadi, "KzHINADI", KzHINADI,
		   kz_hinadi_class_init, kz_hinadi_init,
		   KZ_TYPE_META)

static void
kz_hinadi_class_init (KzHINADIClass *klass)
{
	GObjectClass *object_class;
	KzMETAClass *meta_class;

	parent_class = g_type_class_peek_parent (klass);
	object_class = (GObjectClass *) klass;
	meta_class   = (KzMETAClass *) klass;

	meta_class->kz_meta_parse_from_string = kz_hinadi_parse_from_string;
}

static void
kz_hinadi_init (KzHINADI *hinadi)
{
	hinadi->antenna_uri = NULL;
}

KzHINADI *
kz_hinadi_new (gchar *uri, gchar *title, guint update_interval)
{
	KzHINADI *hinadi = KZ_HINADI(g_object_new(KZ_TYPE_HINADI,
					 "uri", uri,
					 "title", title,
					 "interval", update_interval,
					 NULL));	
	kz_meta_update((KzMETA*)hinadi);

	return hinadi;
}

static gint 
compare_func (gconstpointer a, gconstpointer b)
{
	guint one = ((KzMETAItem*)a)->date;
	guint two = ((KzMETAItem*)b)->date;
	return two-one;
}


static gchar *
kz_hinadi_get_encoding (gchar *src)
{
	gchar *encoding = NULL;
	gchar **lines = NULL;
	gchar *begin_pos, *end_pos, *line_end;;
	
	g_return_val_if_fail(src, NULL);

	lines = g_strsplit(src, "\r\n\r\n", 1);

	begin_pos =  strstr(lines[0], "charset=");
	if (begin_pos)
	{
		begin_pos += 8;
		line_end = strstr(begin_pos, "\r\n");
		end_pos = g_strstr_len(begin_pos, line_end - begin_pos, ";");
		if (end_pos)
			encoding = g_strndup(begin_pos, end_pos - begin_pos);
		else
			encoding = g_strndup(begin_pos, line_end - begin_pos);
	}
	else
		encoding = g_strdup("EUC-JP"); /* default value */

	g_strfreev(lines);
	return encoding;
}


static void
kz_hinadi_parse_from_string (KzMETA *meta, gpointer user_data,
			     const gchar *buffer, guint length,
			     GError **error)
{
	gchar *dest = NULL;
	guint read_len, dest_len;
	gchar **lines    = NULL;
	gchar **elements = NULL;
	guint line_number = 1;
	guint element_number;
	gchar timestr[20];
	gchar *encoding;

	g_return_if_fail(buffer != NULL);

	/* convert to utf-8 encoding */
	encoding = kz_hinadi_get_encoding((gchar*)buffer);	
	dest = g_convert(buffer, length, "UTF-8", encoding,
			 &read_len, &dest_len, NULL);
	g_free(encoding);
	
	lines = g_strsplit(dest, "\r\n\r\n", -1);
	
	while(lines[line_number+1] != NULL)
	{
		KzMETAItem *item;
		struct tm t;
		
		elements = g_strsplit(lines[line_number], "\r\n", 20);
		element_number = 0;
		item = g_new0(KzMETAItem, 1);
		item->meta = meta;
		while(elements[element_number+1] != NULL)
		{
			switch (elements[element_number][0])
			{
			 case 'L':
			 case 'l': /* Last-Modified */
				if(elements[element_number][13] == ':')
				{
					strptime(elements[element_number]+15,
						 "%a, %d %b %Y %H:%M:%S %z", &t);
					item->date  = (guint)mktime(&t);
					strftime(timestr, 20, "%Y/%m/%d %H:%M", &t);
					item->description = g_strdup(timestr);
				}
				break;
			 case 'T':
			 case 't': /* Title */
				item->title = g_strdup(elements[element_number]+6);
				break;
			 case 'U': 
			 case 'u':/* URL */
				item->link =  g_strdup(elements[element_number]+4);
				break;
			 default:
				break;
			}
			element_number++;
		}
		g_strfreev(elements);
		if (!meta->items)
			meta->items = g_slist_append(meta->items, item);
		else
			g_slist_append(meta->items,item);
		line_number++;
	}

	g_strfreev(lines);
	
	/* sorting */
	meta->items = g_slist_sort(meta->items, compare_func);
}
