/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_META_MENU_H__
#define __KZ_META_MENU_H__

#include <gtk/gtk.h>

#include "kz-window.h"
#include "kz-meta.h"

G_BEGIN_DECLS

#define KZ_TYPE_META_MENU	    (kz_meta_menu_get_type ())
#define KZ_META_MENU(obj)	    (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_META_MENU, KzMETAMenu))
#define KZ_META_MENU_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_META_MENU, KzMETAMenuClass))
#define KZ_IS_META_MENU(obj)	    (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_META_MENU))
#define KZ_IS_META_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_META_MENU))
#define KZ_META_MENU_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_META_MENU, KzMETAMenuClass))

typedef struct _KzMETAMenu           KzMETAMenu;
typedef struct _KzMETAMenuClass      KzMETAMenuClass;

struct _KzMETAMenu
{
	GtkHBox parent;

	/* Parent Kazehakase */
	KzWindow *kz;

	/* widget */
	GtkWidget *menu_item;
	GtkWidget *sub_menu;
	GtkWidget *update_button;
	GtkWidget *image;

	KzMETA *meta;
};

struct _KzMETAMenuClass
{
	GtkHBoxClass parent_class;
};

GtkType    kz_meta_menu_get_type (void);
GtkWidget *kz_meta_menu_new      (KzWindow *kz, KzMETA *meta);

G_END_DECLS

#endif /* __KZ_META_MENU_H__ */
