/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <gtk/gtk.h>

#include "gtkmozembed.h"
#include "kazehakase-type.h"
#include "kazehakase.h"
#include "prefs.h"

static void back_clicked_cb    (GtkButton   *button, Kazehakase *kz);
static void enter_button_cb    (GtkButton   *button, Kazehakase *kz);
static void stop_clicked_cb    (GtkButton   *button, Kazehakase *kz);
static void forward_clicked_cb (GtkButton   *button, Kazehakase *kz);
static void reload_clicked_cb  (GtkButton   *button, Kazehakase *kz);
static void home_clicked_cb    (GtkButton   *button, Kazehakase *kz);
static void url_activate_cb    (GtkEntry    *widget, Kazehakase *kz);

static void notebook_switch_page_cb  (GtkNotebook   *notebook, GtkNotebookPage *page,
				      guint page_num, Kazehakase *kz);

void enter_button_cb (GtkButton *button, Kazehakase *kz)
{

}

void back_clicked_cb (GtkButton *button, Kazehakase *kz)
{
	gint n = gtk_notebook_get_current_page(GTK_NOTEBOOK(kz->notebook));
	gtk_moz_embed_go_back(GTK_MOZ_EMBED(gtk_notebook_get_nth_page(GTK_NOTEBOOK(kz->notebook),n)));
}

void stop_clicked_cb (GtkButton *button, Kazehakase *kz)
{
	gint n = gtk_notebook_get_current_page(GTK_NOTEBOOK(kz->notebook));
	gtk_moz_embed_stop_load(GTK_MOZ_EMBED(gtk_notebook_get_nth_page(GTK_NOTEBOOK(kz->notebook),n)));
}

void forward_clicked_cb (GtkButton *button, Kazehakase *kz)
{
	gint n = gtk_notebook_get_current_page(GTK_NOTEBOOK(kz->notebook));
	gtk_moz_embed_go_forward(GTK_MOZ_EMBED(gtk_notebook_get_nth_page(GTK_NOTEBOOK(kz->notebook),n)));
}

void reload_clicked_cb  (GtkButton *button, Kazehakase *kz)
{
	gint n = gtk_notebook_get_current_page(GTK_NOTEBOOK(kz->notebook));
	GdkModifierType state = (GdkModifierType)0;
	gint x, y;
	gdk_window_get_pointer(NULL, &x, &y, &state);

	gtk_moz_embed_reload(GTK_MOZ_EMBED(gtk_notebook_get_nth_page(GTK_NOTEBOOK(kz->notebook),n)),
			     (state & GDK_SHIFT_MASK) ?
			     GTK_MOZ_EMBED_FLAG_RELOADBYPASSCACHE : 
			     GTK_MOZ_EMBED_FLAG_RELOADNORMAL);
}

void home_release_cb  (GtkButton *button, GdkEventButton *event, Kazehakase *kz)
{
	if (event->button == 2)
	  kazehakase_tab_new(kz, prefs.home_uri);
	else
	{
		gint n = gtk_notebook_get_current_page(GTK_NOTEBOOK(kz->notebook));
		gtk_moz_embed_load_url(GTK_MOZ_EMBED(gtk_notebook_get_nth_page(GTK_NOTEBOOK(kz->notebook),n)),
				       prefs.home_uri);
	}
}
void url_activate_cb    (GtkEntry *widget, Kazehakase *kz)
{
	gint n = gtk_notebook_get_current_page(GTK_NOTEBOOK(kz->notebook));
	const gchar *text = gtk_entry_get_text(GTK_ENTRY(widget));

	gtk_moz_embed_load_url(GTK_MOZ_EMBED(gtk_notebook_get_nth_page(GTK_NOTEBOOK(kz->notebook),n)), text);
}

void notebook_switch_page_cb (GtkNotebook *notebook, GtkNotebookPage *page,
			      guint page_num, Kazehakase *kz)
{
	GtkMozEmbed *embed = GTK_MOZ_EMBED(gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), page_num));
	gchar *newTitle, *newLocation;

	newTitle = mozilla_get_title(embed);
	newLocation = gtk_moz_embed_get_location(embed);
	if (newTitle)
	{
		gtk_window_set_title(GTK_WINDOW(kz->topLevelWindow),newTitle);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(kz->urlEntry)->entry), newLocation);
		g_free(newTitle);
	}
	update_nav_buttons(kz, embed);
}

void find_keyword_cb(GtkWidget *widget, Kazehakase *kz)
{
	gboolean didFind;
	gint n = gtk_notebook_get_current_page(GTK_NOTEBOOK(kz->notebook));
	GtkMozEmbed *embed = GTK_MOZ_EMBED(gtk_notebook_get_nth_page(GTK_NOTEBOOK(kz->notebook), n));
	const gchar *text = gtk_entry_get_text(GTK_ENTRY(widget));
	gint k = mozilla_find(embed, text, &didFind);
	printf("find=%d, page=%s\n", k,mozilla_get_title(embed));
}

void update_nav_buttons (Kazehakase *kz, GtkMozEmbed *embed)
{
	gboolean can_go_back;
	gboolean can_go_forward;
	gboolean can_stop;
	
	can_go_back = gtk_moz_embed_can_go_back(GTK_MOZ_EMBED(embed));
	can_go_forward = gtk_moz_embed_can_go_forward(GTK_MOZ_EMBED(embed));

	gtk_widget_set_sensitive(kz->backButton, can_go_back);
	gtk_widget_set_sensitive(kz->forwardButton, can_go_forward);
/*	gtk_widget_set_sensitive(kz->stopButton, can_stop); */
}

Kazehakase *kazehakase_window_new(gchar *url)
{
	GtkWidget *hbox, *menu_hbox, *location_hbox;
	Kazehakase *kz = NULL;
		
	hbox = gtk_hbox_new(FALSE, 0);

	kz = g_new0(Kazehakase, 1);

/*	kz->kzembed_list = NULL; */

	kz->menuBarOn = TRUE;
	kz->toolBarOn = TRUE;
	kz->locationBarOn = TRUE;
	kz->statusBarOn = TRUE;

	/* create our new toplevel window */
	kz->topLevelWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	/* new vbox */
	kz->topLevelVBox = gtk_vbox_new(FALSE, 0);
	/* add it to the toplevel window */
	gtk_container_add(GTK_CONTAINER(kz->topLevelWindow),
			  kz->topLevelVBox);
	/* create our menu bar */
	kz->menuBar = gtk_menu_bar_new();
	/* create the file menu */
	kz->fileMenuItem = gtk_menu_item_new_with_label("File");
	kz->fileMenu = gtk_menu_new();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM(kz->fileMenuItem),
				   kz->fileMenu);

	kz->fileClose =
	  gtk_menu_item_new_with_label("Close");
	gtk_menu_shell_append(GTK_MENU_SHELL(kz->fileMenu),
			      kz->fileClose);

	kz->fileQuit =
	  gtk_menu_item_new_with_label("Quit");
	gtk_menu_shell_append(GTK_MENU_SHELL(kz->fileMenu),
			      kz->fileQuit);
  
	// append it
	gtk_menu_shell_append(GTK_MENU_SHELL(kz->menuBar), kz->fileMenuItem);
/*
	gtk_box_pack_start(GTK_BOX(hbox),
			   kz->menuBar,
			   FALSE, // expand
			   FALSE, // fill
			   0);    // padding
*/	
	/* new horiz toolbar with buttons + icons */
	kz->toolbar = gtk_toolbar_new();
	gtk_toolbar_set_orientation(GTK_TOOLBAR(kz->toolbar),
				    GTK_ORIENTATION_HORIZONTAL);
	gtk_toolbar_set_style(GTK_TOOLBAR(kz->toolbar),
			      GTK_TOOLBAR_ICONS);

	gtk_toolbar_set_icon_size(GTK_TOOLBAR(kz->toolbar),
				  GTK_ICON_SIZE_SMALL_TOOLBAR);

	/* new back button */
	kz->backButton =
	  gtk_toolbar_insert_stock(GTK_TOOLBAR(kz->toolbar),
//	  gtk_toolbar_append_item(GTK_TOOLBAR(kz->toolbar),
//			    "Back",
			    GTK_STOCK_GO_BACK,
			    "Go Back",
			    "Go Back",
			    GTK_SIGNAL_FUNC(back_clicked_cb),
			    kz,1);
	g_signal_connect(G_OBJECT(kz->backButton),"enter",
			 G_CALLBACK(enter_button_cb), kz);
	/* new forward button */
	kz->forwardButton =
	  gtk_toolbar_insert_stock(GTK_TOOLBAR(kz->toolbar),
//	  gtk_toolbar_append_item(GTK_TOOLBAR(kz->toolbar),
//			    "Forward",
			    GTK_STOCK_GO_FORWARD,
			    "Forward",
			    "Forward",
			    GTK_SIGNAL_FUNC(forward_clicked_cb),
			    kz,2);
	/* new stop button */
	kz->stopButton = 
	  gtk_toolbar_insert_stock(GTK_TOOLBAR(kz->toolbar),
//	  gtk_toolbar_append_item(GTK_TOOLBAR(kz->toolbar),
//			    "Stop",
			    GTK_STOCK_STOP,
			    "Stop",
			    "Stop",
			    GTK_SIGNAL_FUNC(stop_clicked_cb),
			    kz,3);
	/* new reload button */
	kz->reloadButton = 
	  gtk_toolbar_insert_stock(GTK_TOOLBAR(kz->toolbar),
//	  gtk_toolbar_append_item(GTK_TOOLBAR(kz->toolbar),
//			    "Reload",
			    GTK_STOCK_REFRESH,
			    "Reload",
			    "Reload",
			    GTK_SIGNAL_FUNC(reload_clicked_cb),
			    kz,4);
	
	/* new home button */
	kz->homeButton = 
	  gtk_toolbar_insert_stock(GTK_TOOLBAR(kz->toolbar),
			    GTK_STOCK_HOME,
			    "Home",
			    "Home",
			    NULL, 
			    kz,5);
	g_signal_connect(G_OBJECT(kz->homeButton), "button_release_event",
			 G_CALLBACK(home_release_cb),kz);
	/* add it to the hbox */
	gtk_box_pack_start(GTK_BOX(hbox), kz->toolbar,
			   FALSE,
			   FALSE,
			   0);   

	/* create the url text entry */
	kz->urlEntry = gtk_combo_new();
	gtk_combo_disable_activate(GTK_COMBO(kz->urlEntry));
	/* add it to the hbox */
	gtk_box_pack_start(GTK_BOX(hbox), kz->urlEntry,
			   TRUE, 
			   TRUE, 
			   0);   
	
	/* hook up the activate signal to the right callback */
	g_signal_connect(G_OBJECT(GTK_COMBO(kz->urlEntry)->entry), "activate",
			 G_CALLBACK(url_activate_cb), kz);

	/* add that hbox to the vbox */
	gtk_box_pack_start(GTK_BOX(kz->topLevelVBox), 
			   hbox,
			   FALSE, 
			   FALSE, 
			   0);    

	/* create notebook widget */
	kz->notebook = gtk_notebook_new();
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(kz->notebook), TRUE);
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(kz->notebook), TRUE);
	g_signal_connect(G_OBJECT(kz->notebook), "switch_page", 
			 G_CALLBACK(notebook_switch_page_cb), kz);

	gtk_container_add(GTK_CONTAINER(kz->topLevelVBox), kz->notebook);
	
	/* create new mozembed tab */
	kazehakase_tab_new(kz, url);

	/* create the new hbox for the search area */
	kz->findAreaHBox = gtk_hbox_new(FALSE, 0);
	/* add it to the vbox */
	gtk_box_pack_start(GTK_BOX(kz->topLevelVBox), kz->findAreaHBox,
			   FALSE, 
			   FALSE, 
			   0);   
	/* create our new progress bar */
	kz->findArea = gtk_entry_new();
	/* add it to the hbox */
	gtk_box_pack_start(GTK_BOX(kz->findAreaHBox), kz->findArea,
			   FALSE,
			   FALSE,
			   0); 
	g_signal_connect(G_OBJECT(GTK_ENTRY(kz->findArea)), "activate",
			 G_CALLBACK(find_keyword_cb), kz);
	
	/* create our status area and the alignment object that will keep it */
	/* from expanding */
	kz->statusAlign = gtk_alignment_new(0, 0, 1, 1);
	gtk_widget_set_size_request(kz->statusAlign, 1, -1);
	/* create the status bar */
	kz->statusBar = gtk_statusbar_new();
	gtk_container_add(GTK_CONTAINER(kz->statusAlign), kz->statusBar);
	/* add it to the hbox */
	gtk_box_pack_start(GTK_BOX(kz->findAreaHBox), kz->statusAlign,
			   TRUE, 
			   TRUE, 
			   0);   
	/* by default none of the buttons are marked as sensitive. */
	gtk_widget_set_sensitive(kz->backButton, FALSE);
//	gtk_widget_set_sensitive(kz->stopButton, FALSE);
	gtk_widget_set_sensitive(kz->forwardButton, FALSE);
//	gtk_widget_set_sensitive(kz->reloadButton, FALSE);
	gtk_widget_show(kz->notebook);
	gtk_widget_show_all(kz->topLevelVBox);

	/* FIX ME! set last window size! */ 
	gtk_window_set_default_size(GTK_WINDOW(kz->topLevelWindow), 
				    prefs.width, prefs.height);
	g_signal_connect(G_OBJECT(kz->topLevelWindow), "delete_event",
			 G_CALLBACK(gtk_main_quit), NULL);

	gtk_widget_show_all(kz->topLevelWindow);
	
	return kz;
}

void set_browser_visibility (Kazehakase *kz, gboolean visibility)
{
	if (!visibility)
	{
		gtk_widget_hide(kz->topLevelWindow);
		return;
	}
  
	if (kz->menuBarOn)
	  gtk_widget_show_all(kz->menuBar);
	else
	  gtk_widget_hide_all(kz->menuBar);

	// since they are on the same line here...
//	if (kz->toolBarOn || kz->locationBarOn)
//	  gtk_widget_show_all(kz->toolbarHBox);
//	else 
//	  gtk_widget_hide_all(kz->toolbarHBox);

	if (kz->statusBarOn)
	  gtk_widget_show_all(kz->findAreaHBox);
	else
	  gtk_widget_hide_all(kz->findAreaHBox);

	gtk_widget_show(kz->notebook);
	gtk_widget_show(kz->topLevelVBox);
	gtk_widget_show(kz->topLevelWindow);
}
