AC_DEFUN([KAZEHAKASE_GECKO_API_CHECK],
[
dnl *************************************************************************
dnl This is from Mozilla's configure.in. They set almost all the config stuff
dnl they need in mozilla-config.h Except for this compiler flag, which can't
dnl go in mozilla-config.h So we check the flag too and now we can include
dnl mozilla-config.h without breaking epiphany.
dnl This is really gcc-only
dnl Do this test using CXX only since some versions of gcc
dnl 2.95-2.97 have a signed wchar_t in c++ only and some versions
dnl only have short-wchar support for c++.
AC_LANG_PUSH(C++)
_SAVE_CPPFLAGS=$CPPFLAGS
_SAVE_CXXFLAGS=$CXXFLAGS
_SAVE_AM_CXXFLAGS=$AM_CXXFLAGS
AM_CXXFLAGS="$AM_CXXFLAGS -fshort-wchar"
CXXFLAGS="$CXXFLAGS $AM_CXXFLAGS"

AC_CACHE_CHECK(for compiler -fshort-wchar option,
    ac_cv_have_usable_wchar_option,
    [AC_TRY_RUN([#include <stddef.h>
                 int main () {
                   return (sizeof(wchar_t) != 2) ||
                          (wchar_t)-1 < (wchar_t) 0 ; } ],
                ac_cv_have_usable_wchar_option="yes",
                ac_cv_have_usable_wchar_option="no",
                ac_cv_have_usable_wchar_option="maybe")])

if test "$ac_cv_have_usable_wchar_option" != "yes"; then
    AM_CXXFLAGS=$_SAVE_AM_CXXFLAGS
fi

CPPFLAGS="-I$MOZILLA_INCLUDE_ROOT -I$MOZILLA_INCLUDE_ROOT/widget -I$MOZILLA_INCLUDE_ROOT/layout -I$MOZILLA_INCLUDE_ROOT/helperAppDlg -I$MOZILLA_INCLUDE_ROOT/dom -I$MOZILLA_INCLUDE_ROOT/exthandler -I$MOZILLA_INCLUDE_ROOT/pipnss -I$MOZILLA_INCLUDE_ROOT/necko -I$MOZILLA_INCLUDE_ROOT/gfx -I$MOZILLA_INCLUDE_ROOT/content -I$MOZILLA_INCLUDE_ROOT/locale -I$MOZILLA_INCLUDE_ROOT/docshell `$PKG_CONFIG --cflags-only-I $GECKO-xpcom` -Wconversion -Wsign-compare -Werror"
CXXFLAGS="$AM_CXXFLAGS `$PKG_CONFIG --cflags-only-other $GECKO-xpcom`"

AC_MSG_RESULT([$CXXFLAGS])
dnl **************************************************************
dnl Check Mozilla API .
dnl This code picked from Epiphany-1.7.0.
dnl **************************************************************

dnl Changed from PRUnichar* to nsAString& in 1.8a1 and on aviary branch

dnl Determine gecko version
dnl We don't use the version from the .pc file, since that's the app version
dnl and not the Gecko version

AC_MSG_CHECKING([[for gecko version]])

gecko_version=`cat $MOZILLA_INCLUDE_ROOT/mozilla-config.h | grep MOZILLA_VERSION_U | awk '{ print $[3]; }' | tr ".ab+" " "`
if test -z "$gecko_version"; then
	gecko_version="1 7"
fi

gecko_version_major=`echo $gecko_version | awk '{ print $[1]; }'`
gecko_version_minor=`echo $gecko_version | awk '{ print $[2]; }'`

if test -n "$gecko_version_major" -a -n "$gecko_version_minor"; then
	AC_MSG_RESULT([$gecko_version_major.$gecko_version_minor])
else
	AC_MSG_RESULT([no])
	AC_MSG_ERROR([Can't detect Gecko version])
fi

if test $gecko_version_major -ne 1 -o \
		$gecko_version_minor -lt 7 -o \
		$gecko_version_minor -gt 9; then
	AC_MSG_ERROR([Unsupported Gecko version $gecko_version_major.$gecko_version_minor])
fi

if test $gecko_version_major -eq 1 -a $gecko_version_minor -ge 8; then
	AC_DEFINE([HAVE_GECKO_1_8],[1],[Define if we have gecko 1.8])
fi
if test $gecko_version_major -eq 1 -a $gecko_version_minor -ge 9; then
	AC_DEFINE([HAVE_GECKO_1_9],[1],[Define if we have gecko 1.9])
fi

AC_MSG_CHECKING([whether nsPIDOMWindow methods return nsPIDOMWindow*])

AC_COMPILE_IFELSE(
	[AC_LANG_PROGRAM(
		[[#include <nsPIDOMWindow.h>]],
		[[nsPIDOMWindow *w;
		  w->GetPrivateRoot ();]]
	)],
	[AC_DEFINE([MOZ_NSPIDOMWINDOW_RETURNNSPIDOMWINDOW_],[1],[Define if nsPIDOMWindow returns nsPIDOMWindow*]) result=yes],
	[result=no])

AC_MSG_RESULT([$result])

AC_MSG_CHECKING([whether nsIFilePicker methods expect nsAString&])

AC_COMPILE_IFELSE(
	[AC_LANG_PROGRAM(
		[[#include <nsEmbedString.h>
		  #include <widget/nsIFilePicker.h>]],
		[[nsIFilePicker *p;
		  p->SetDefaultString (nsEmbedString());]]
	)],
	[AC_DEFINE([MOZ_NSIFILEPICKER_NSASTRING_],[1],[Define if nsIFilePicker uses nsAString&]) result=yes],
	[result=no])

AC_MSG_RESULT([$result])

dnl Changed from char* to nsAString& in 1.8a1

AC_MSG_CHECKING([whether nsIMIMEInfo methods expect nsAString&])

AC_COMPILE_IFELSE(
	[AC_LANG_PROGRAM(
		[[#include <nsEmbedString.h>
		  #include <mimetype/nsIMIMEInfo.h>]],
		[[nsIMIMEInfo *p;
		  p->SetDescription (nsEmbedString());]]
	)],
	[AC_DEFINE([MOZ_NSIMIMEINFO_NSACSTRING_],[1],[Define if nsIMIMEInfo uses nsAString&]) result=yes],
	[result=no])

AC_MSG_RESULT([$result])

AC_MSG_CHECKING([whether nsICacheSession methods expect nsAString&])

AC_COMPILE_IFELSE(
	[AC_LANG_PROGRAM(
		[[#include <nsEmbedString.h>
		  #include <nkcache/nsICacheSession.h>]],
		[[nsICacheSession *p;
		  p->OpenCacheEntry (nsEmbedCString(),0, PR_FALSE, nsnull);]]
	)],
	[AC_DEFINE([MOZ_NSICACHESESSION_NSACSTRING_],[1],[Define if nsICacheSession uses nsAString&]) result=yes],
	[result=no])

AC_MSG_RESULT([$result])

AC_MSG_CHECKING([whether nsIHelperAppLauncherDialog methods expect PRBool])

AC_COMPILE_IFELSE(
	[AC_LANG_PROGRAM(
		[[#include <nsIHelperAppLauncherDialog.h>]],
		[[nsIHelperAppLauncherDialog *p;
		  p->Show (nsnull, nsnull, -1);]]
	)],
	[AC_DEFINE([MOZ_NSIHELPERAPPLAUNCHERDIALOG_NSPRBOOL_],[1],[Define if nsIHelperAppLauncharDialog uses PRBool]) result=yes],
	[result=no])

AC_MSG_RESULT([$result])

AC_MSG_CHECKING([whether NS_InitXPCOM3 exists])

AC_COMPILE_IFELSE(
	[AC_LANG_PROGRAM(
		[[#include <nsXPCOM.h>]],
		[[NS_InitXPCOM3(nsnull, nsnull, nsnull, nsnull, 0);]]
	)],
	[AC_DEFINE([MOZ_HAVE_NSINITXPCOM3_],[1],[Define if Gecko has NS_InitXPCOM3]) result=yes],
	[result=no])

AC_MSG_RESULT([$result])

AC_COMPILE_IFELSE(
	[AC_LANG_PROGRAM(
		[[#define MOZILLA_INTERNAL_API
		  #include <nsICanvasRenderingContextInternal.h>
		  #include <nsEmbedString.h>
		  #undef MOZILLA_INTERNAL_API]],
		[[nsICanvasRenderingContextInternal *p;
		  p->GetInputStream (nsEmbedCString(), nsEmbedString(), nsnull);]]
	)],
	[AC_DEFINE([MOZ_NSICANVASRENDERINGCONTEXTINTERNAL_HAVE_GETINPUTSTREAM_],[1],[Define if nsICanvasRenderingContextInternal has GetInputStream]) no_nsicanvasrenderingcontextinternal_have_getinputstream=yes],
	[no_nsicanvasrenderingcontextinternal_have_getinputstream=no])

AC_MSG_RESULT([$result])

AC_CHECK_FILE([$MOZILLA_INCLUDE_ROOT/content/nsICanvasRenderingContextInternal.h],
	[AC_DEFINE([HAVE_NSICANVASRENDERINGCONTEXTINTERNAL_H],[1],[Define if nsICanvasRenderingContextInternal.h exists])])

AC_CHECK_FILE([$MOZILLA_INCLUDE_ROOT/nsIWebProgressListener2.h],
	[AC_DEFINE([HAVE_NSIWEBPROGRESSLISTENER2_H],[1],[Define if nsIWebProgressListener2.h exists])],
	[AC_CHECK_FILE([$MOZILLA_INCLUDE_ROOT/uriloader/nsIWebProgressListener2.h],
		[AC_DEFINE([HAVE_NSIWEBPROGRESSLISTENER2_H],[1],[Define if nsIWebProgressListener2.h exists])])])

AC_CHECK_FILE([$MOZILLA_INCLUDE_ROOT/nsITransfer.h],
	[AC_DEFINE([HAVE_NSITRANSFER_H],[1],[Define if nsITransfer.h exists])],
	[AC_CHECK_FILE([$MOZILLA_INCLUDE_ROOT/uriloader/nsITransfer.h],
		[AC_DEFINE([HAVE_NSITRANSFER_H],[1],[Define if nsITransfer.h exists])])])

AC_CHECK_FILE([$MOZILLA_INCLUDE_ROOT/nsIPresContext.h],
	[AC_DEFINE([HAVE_NSIPRESCONTEXT_H],[1],[Define if nsIPresContext.h exists])],
	[AC_CHECK_FILE([$MOZILLA_INCLUDE_ROOT/layout/nsIPresContext.h],
		[AC_DEFINE([HAVE_NSIPRESCONTEXT_H],[1],[Define if nsIPresContext.h exists])])])

dnl Not a simple file check due to the header being in the SDK since 1.8a6
dnl https://bugzilla.mozilla.org/show_bug.cgi?id=271068

AC_CHECK_FILES([$MOZILLA_INCLUDE_ROOT/nsIPassword.h
		$MOZILLA_INCLUDE_ROOT/wallet/nsIPassword.h
		$MOZILLA_INCLUDE_ROOT/passwordmgr/nsIPassword.h],
	[AC_DEFINE([HAVE_NSIPASSWORD_H],[1],
	[Define if mozilla nsIPassword header is available])])

dnl Check for nsIDocShell::GetSecurityUI
dnl This code is picked from galeon-1.3.21.
dnl nsIDocShell::GetSecurityUI was added in 1.8b2 as part of the fastback
dnl patch
dnl https://bugzilla.mozilla.org/show_bug.cgi?id=274784

AC_MSG_CHECKING([whether nsIDocShell::GetSecureUI exists])
AC_COMPILE_IFELSE(
	[AC_LANG_PROGRAM(
		[[#include <nsIDocShell.h>]],
		[[ nsIDocShell *p;
		   p->GetSecurityUI( nsnull ); ]]
	)],
	[AC_DEFINE([HAVE_NSIDOCSHELL_GETSECUREUI], [1],
		   [Define if nsIDocShell::GetSecureUI exists]) result=yes],
	[result=no])
AC_MSG_RESULT([$result])
dnl restore flags
CPPFLAGS=$_SAVE_CPPFLAGS
CXXFLAGS=$_SAVE_CXXFLAGS

AC_LANG_POP([C++])

])
AC_DEFUN([KAZEHAKASE_GECKO_CHECK],
[

GECKO=
AC_ARG_WITH([gecko_engine],
	AS_HELP_STRING([--with-gecko-engine@<:@=mozilla|firefox|thunderbird|seamonkey|xulrunner@:>@],
		       [Whether to use mozilla, firefox or thunderbird or seamonkey xpcom (default: mozilla)]),
	[GECKO="$withval"])

AC_MSG_CHECKING([for gecko engine])
if test "x$GECKO" = "xno"; then
  GECKO=
  gecko_engine_not_found_message="disabled"
elif test "x$GECKO" = "x"; then
  dnl try to autodetect: if mozilla exists, use it, else try firefox,
  dnl then thunderbird
  if $PKG_CONFIG --exists firefox-xpcom; then
    GECKO=firefox
  elif $PKG_CONFIG --exists mozilla-firefox-xpcom; then
    GECKO=mozilla-firefox
  elif $PKG_CONFIG --exists mozilla-xpcom; then
    GECKO=mozilla
  elif $PKG_CONFIG --exists seamonkey-xpcom; then
    GECKO=seamonkey
  elif $PKG_CONFIG --exists thunderbird-xpcom; then
    GECKO=thunderbird
  elif $PKG_CONFIG --exists xulrunner-xpcom; then
    GECKO=xulrunner
  else
    gecko_engine_not_found_message="not found"
  fi
elif test "x$with_gecko_engine" != "xmozilla" -a "x$with_gecko_engine" != "xfirefox" -a "x$with_gecko_engine" != "xthunderbird" -a "x$with_gecko_engine" != "xseamonkey" -a "x$with_gecko_engine" != "xmozilla-firefox" -a "x$with_gecko_engine" != "xxulrunner"; then
  AC_MSG_ERROR([unknown gecko engine name ($GECKO)])
fi

AM_CONDITIONAL(WITH_GECKO, test "x$GECKO" != "x")

if test "x$GECKO" = "x"; then
  AC_MSG_RESULT([$gecko_engine_not_found_message])
else
  AC_SUBST(GECKO)
  AC_DEFINE([WITH_GECKO],[1],[Define using Gecko support])
  
  AC_MSG_RESULT([$GECKO])
  
  case "$GECKO" in
  mozilla) min_version=1.7 ;;
  seamonkey) min_version=1.0 ;;
  firefox) min_version=1.0 ;;
  mozilla-firefox) min_version=1.0 ;;
  thunderbird) min_version=0.8 ;;
  xulrunner) min_version=1.8 ;;
  esac
  
  dnl **************************************************************
  dnl Check for including gtkmozembed.
  dnl **************************************************************
  AC_ARG_ENABLE(gtkmozembed, [  --enable-gtkmozembed
  			  Enable including GtkMozEmbed module],,
  		enable_gtkmozembed=yes)
  if test x"$enable_gtkmozembed" = "xyes"; then
    GECKO_MODULE=$GECKO-xpcom
  else
    GECKO_MODULE=$GECKO-gtkmozembed
  fi
  
  PKG_CHECK_MODULES(MOZILLA_COMPONENT, $GECKO_MODULE >= $min_version)
  
  AC_SUBST(MOZILLA_COMPONENT_CFLAGS)
  AC_SUBST(MOZILLA_COMPONENT_LIBS)
  
  MOZILLA_COMPONENT_VERSION="`$PKG_CONFIG --modversion $GECKO_MODULE`"
  AC_SUBST(MOZILLA_COMPONENT_VERSION)
  
  MOZILLA_INCLUDE_ROOT="`$PKG_CONFIG --variable=includedir $GECKO-xpcom`"
  AC_SUBST(MOZILLA_INCLUDE_ROOT)
  
  MOZILLA_HOME="`$PKG_CONFIG --variable=libdir $GECKO-xpcom`"
  AC_SUBST(MOZILLA_HOME)
  
  MOZILLA_PREFIX="`$PKG_CONFIG --variable=prefix $GECKO-xpcom`"
  AC_SUBST(MOZILLA_PREFIX)
  
  KAZEHAKASE_GECKO_API_CHECK
fi

AM_CONDITIONAL(ENABLE_GTKMOZEMBED, test x"$enable_gtkmozembed" = "xyes")

have_gecko_version_1_8=no
have_gecko_version_1_9=no
if test -n "$gecko_version_major" -a -n "$gecko_version_minor"; then
	if test $gecko_version_major -eq 1; then
		if test $gecko_version_minor -ge 8; then
			have_gecko_version_1_8=yes
		fi
		if test $gecko_version_minor -ge 9; then
			have_gecko_version_1_9=yes
		fi
	fi
fi

AM_CONDITIONAL([HAVE_GECKO_1_8], [test $have_gecko_version_1_8 = "yes"])
AM_CONDITIONAL([HAVE_GECKO_1_9], [test $have_gecko_version_1_9 = "yes"])
AM_CONDITIONAL([MOZ_NO_NSICANVASRENDERINGCONTEXTINTERNAL_HAVE_GETINPUTSTREAM_],
               [test "$no_nsicanvasrenderingcontextinternal_have_getinputstream" = "no"])

])
