/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_IO_H__
#define __KZ_IO_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define KZ_TYPE_IO		(kz_io_get_type ())
#define KZ_IO(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_IO, KzIO))
#define KZ_IO_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_IO, KzIOClass))
#define KZ_IS_IO(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_IO))
#define KZ_IS_IO_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_IO))
#define KZ_IO_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_IO, KzIOClass))

#define KZ_TYPE_IO_MODE (kz_io_mode_type_get_type())

typedef struct _KzIO KzIO;
typedef struct _KzIOClass KzIOClass;

typedef enum {
	KZ_IO_READ,
	KZ_IO_WRITE
} KzIOMode;

struct _KzIO
{
	GObject parent;

	GIOChannel *iochannel;
	KzIOMode mode;

	gchar *uri;

	guint last_modified;
	guint file_size;
	gsize bytes_loaded;

	int fd; /* file descriptor for temporary file */
	gchar *tempfile;
	GIOChannel *tempio; /* iochannel for temporary file */

	gboolean cancel;
	
	gchar *write_str; /* writing buffer */
	gboolean inmemory; /* loading in memory if TRUE */
	
	GString *memory_buffer; /* buffer for inmemory mode */
};

struct _KzIOClass
{
	GObjectClass parent_class;

	/* -- signals -- */
	void (*io_in)               (KzIO *io, guint len, const gchar *buf);
	void (*io_out)              (KzIO *io, guint len, const gchar *buf);
	void (*io_completed)        (KzIO *io);
	void (*io_error)            (KzIO *io);
	void (*io_redirect)         (KzIO *io, gchar *new_uri);
	
	/* */
	void (*emit_io_in_signal)     (KzIO *io, guint len, const gchar* buf);
	void (*emit_io_out_signal)    (KzIO *io, guint len, const gchar* buf);
	void (*emit_error_signal)     (KzIO *io);
	void (*emit_completed_signal) (KzIO *io);
	void (*set_io_channel)        (KzIO *io);

	/* for virtual function */
	GIOStatus (*kz_io_in)         (KzIO *io, GIOChannel *iochannel);
	GIOStatus (*kz_io_out)        (KzIO *io, GIOChannel *iochannel);
	void (*kz_io_start)           (KzIO *io);
	void (*kz_io_stop)            (KzIO *io);

};

GType  kz_io_method_type_get_type (void);

GType  kz_io_get_type         (void);
KzIO  *kz_io_new              (const gchar *uri, KzIOMode mode);
KzIO  *kz_io_new_in_memory    (const gchar *uri, KzIOMode mode);
void   kz_io_dispose          (GObject *object);

void   kz_io_start            (KzIO *io);
void   kz_io_stop             (KzIO *io);

gchar *kz_io_get_string       (KzIO *io);
gsize  kz_io_get_file_size    (KzIO *io);
gsize  kz_io_get_loaded_size  (KzIO *io);
guint  kz_io_get_lastmodified (KzIO *io);

void   kz_io_set_string       (KzIO *io, gchar *str);

G_END_DECLS

#endif /* __KZ_IO_H__ */
