/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  This action is temporary solution to create a google item.
 *  We'll replace this with KzBookmark and KzBookmarkAction.
 *  (Smart bookmark)
 */

#include "google-action.h"

#include "google.h"
#include "intl.h"
#include "gobject-utils.h"
#include "kz-icons.h"

static void google_action_class_init (GoogleActionClass *class);
static void google_action_init       (GoogleAction      *action);
static void google_action_dispose    (GObject *obj);

static GtkWidget *google_action_create_tool_item (EggAction *action);
static GtkCombo  *google_action_get_combo_widget (EggHistoryAction *action,
						  GtkWidget *proxy);

static EggHistoryActionClass *parent_class = NULL;


KZ_OBJECT_GET_TYPE(google_action, "GoogleAction", GoogleAction,
		   google_action_class_init, google_action_init,
		   EGG_TYPE_HISTORY_ACTION)


static void
google_action_class_init (GoogleActionClass *klass)
{
	GObjectClass *object_class;
	EggActionClass *action_class;
	EggHistoryActionClass *histact_class;

	parent_class  = g_type_class_peek_parent(klass);
	object_class  = G_OBJECT_CLASS(klass);
	action_class  = EGG_ACTION_CLASS(klass);
	histact_class = EGG_HISTORY_ACTION_CLASS(klass);

	object_class->dispose          = google_action_dispose;

	action_class->create_tool_item = google_action_create_tool_item;
#if 0
	action_class->activate         = google_action_activate;
	action_class->connect_proxy    = google_action_connect_proxy;
	action_class->disconnect_proxy = google_action_disconnect_proxy;
#endif

	histact_class->get_combo_widget = google_action_get_combo_widget;
}


static void
google_action_init (GoogleAction *action)
{
}


static void
google_action_dispose (GObject *obj)
{
	GoogleAction *action = GOOGLE_ACTION(obj);

	g_object_unref(action->kz);

	if (G_OBJECT_CLASS(parent_class)->dispose)
		G_OBJECT_CLASS(parent_class)->dispose(obj);
}


static GtkWidget *
google_action_create_tool_item (EggAction *action)
{
	GType toolbar_item_type;
	GtkWidget *widget, *google;

	toolbar_item_type = EGG_ACTION_GET_CLASS(action)->toolbar_item_type;
	widget = GTK_WIDGET(g_object_new(toolbar_item_type, NULL));

	google = google_new(GOOGLE_ACTION(action)->kz);
	gtk_container_add(GTK_CONTAINER(widget), google);
	gtk_widget_show(google);

	return widget;
}


static GtkCombo *
google_action_get_combo_widget (EggHistoryAction *action, GtkWidget *proxy)
{
	Google *google;

	g_return_val_if_fail(proxy, NULL);

	google = google_get(proxy);
	if (google)
		return GTK_COMBO(google->KeywordEntry);

	return NULL;
}


GoogleAction *
google_action_new (KzWindow *kz)
{
	GoogleAction *action;

	action = GOOGLE_ACTION(g_object_new(TYPE_GOOGLE_ACTION,
					    "name",      "Google",
					    "label",     _("_Google"),
					    "tooltip",   NULL,
					    "stock_id",  KZ_STOCK_GOOGLE,
					    NULL));
	action->kz = g_object_ref(kz);

	return action;
}
