/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef KZ_SCRAP_BOOKMARK_ACTION_H
#define KZ_SCRAP_BOOKMARK_ACTION_H

#include <gtk/gtk.h>

#include "egg-action.h"
#include "kz-bookmark.h"
#include "kz-window.h"

#define KZ_TYPE_SCRAP_BOOKMARK_ACTION            (kz_scrap_bookmark_action_get_type())
#define KZ_SCRAP_BOOKMARK_ACTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), KZ_TYPE_SCRAP_BOOKMARK_ACTION, KzScrapBookmarkAction))
#define KZ_SCRAP_BOOKMARK_ACTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), KZ_TYPE_SCRAP_BOOKMARK_ACTION, KzScrapBookmarkActionClass))
#define KZ_IS_SCRAP_BOOKMARK_ACTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), KZ_TYPE_SCRAP_BOOKMARK_ACTION))
#define KZ_IS_SCRAP_BOOKMARK_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((obj), KZ_TYPE_SCRAP_BOOKMARK_ACTION))
#define KZ_SCRAP_BOOKMARK_ACTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), KZ_TYPE_SCRAP_BOOKMARK_ACTION, KzScrapBookmarkActionClass))

typedef struct _KzScrapBookmarkAction      KzScrapBookmarkAction;
typedef struct _KzScrapBookmarkActionClass KzScrapBookmarkActionClass;

struct _KzScrapBookmarkAction
{
	EggAction   parent;

	GtkWidget  *popup_menu;

	KzBookmark *scrap;
	KzWindow   *kz;
};

struct _KzScrapBookmarkActionClass
{
	EggActionClass parent_class;
};

GType         kz_scrap_bookmark_action_get_type (void);
KzScrapBookmarkAction *kz_scrap_bookmark_action_new (KzBookmark *scrap,
	 					     KzWindow   *kz);

#endif /* KZ_SCRAP_BOOKMARK_ACTION_H */
