/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "migemo.h"
#include "kazehakase.h"

gboolean
migemo_init (void)
{
	gboolean ret;
	GSpawnFlags flags;
	gint argc;
	gchar **argv = NULL;
	gchar *migemo_command;
	
	if (!migemo)
		migemo = g_new0(Migemo, 1);
	
	migemo_command = KZ_CONF_GET_STR("Global", "migemo_command");
	if (!migemo_command)
		migemo_command = g_strdup("migemo -t egrep -d /usr/share/migemo/migemo-dict");

	g_shell_parse_argv(migemo_command,
			   &argc,
			   &argv,
			   NULL);

	flags = G_SPAWN_SEARCH_PATH;
	ret = g_spawn_async_with_pipes(NULL,
				       argv,
				       NULL,
				       flags,
				       NULL,
				       NULL,
				       &migemo->pid,
				       &migemo->input,
				       &migemo->output,
				       &migemo->error,
				       NULL);	
	g_strfreev(argv);
	g_free(migemo_command);
	
	if (!ret)
	{
		g_free(migemo);
		migemo = NULL;
	}			

	return ret;
}

void
migemo_exit (void)
{
#if (GLIB_MAJOR_VERSION == 2) && (GLIB_MINOR_VERSION > 3)
	g_spawn_close_pid(migemo->pid);
#endif	
	g_free(migemo);
}

gchar *
migemo_get_regex(const gchar *text)
{
	GIOChannel *in;
	GIOChannel *out;
	GError *e = NULL;
	gchar *write_buf, *read_buf = NULL, *ret = NULL;
	gsize bytes;
	
	g_return_val_if_fail(migemo, NULL);
	g_return_val_if_fail(text, NULL);
	
	in  = g_io_channel_unix_new(migemo->input);
	out = g_io_channel_unix_new(migemo->output);
	
	g_io_channel_set_encoding(in, NULL, NULL);
	g_io_channel_set_encoding(out, NULL, NULL);

	write_buf = g_strconcat(text, "\n", NULL);
	g_io_channel_write_chars(in,
				 write_buf,
				 strlen(write_buf),
				 &bytes,
				 NULL);
	g_io_channel_flush(in, NULL);
	g_free(write_buf);

	g_io_channel_read_line(out,
			       &read_buf,
			       &bytes,
			       NULL,
			       &e);
	if (e)
	{
		g_warning("%s", e->message);
		g_error_free(e);
	}


	g_io_channel_unref(in);
	g_io_channel_unref(out);

	if (read_buf)
	{
		ret = g_convert(read_buf, strlen(read_buf),
				"UTF-8", "EUC-JP",
				NULL, NULL, NULL);
		g_free(read_buf);
	}

	return ret;
}
