/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_THUMBNAIL_H__
#define __KZ_THUMBNAIL_H__

#include <gtk/gtk.h>
#include "kz-input-event-box.h"

G_BEGIN_DECLS

#define KZ_TYPE_THUMBNAIL		(kz_thumbnail_get_type ())
#define KZ_THUMBNAIL(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_THUMBNAIL, KzThumbnail))
#define KZ_THUMBNAIL_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_THUMBNAIL, KzThumbnailClass))
#define KZ_IS_THUMBNAIL(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_THUMBNAIL))
#define KZ_IS_THUMBNAIL_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_THUMBNAIL))
#define KZ_THUMBNAIL_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_THUMBNAIL, KzThumbnailClass))

typedef struct _KzThumbnail           KzThumbnail;
typedef struct _KzThumbnailClass      KzThumbnailClass;
typedef struct _KzThumbnailPriv	      KzThumbnailPriv;

struct _KzThumbnail
{
	KzInputEventBox parent;

	GtkWidget *image;
};

struct _KzThumbnailClass
{
	KzInputEventBoxClass parent_class;
};

GtkType    kz_thumbnail_get_type (void);
GtkWidget *kz_thumbnail_new      (void);

void	   kz_thumbnail_set_pixbuf             (KzThumbnail *thumbnail,
						GdkPixbuf *pixbuf);
void	   kz_thumbnail_set_thumbnail_from_uri (KzThumbnail *thumbnail,
						const gchar *uri);

G_END_DECLS

#endif /* __KZ_THUMBNAIL_H__ */
