/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef KZ_NAVIGATION_ACTION_H
#define KZ_NAVIGATION_ACTION_H

#include <gtk/gtk.h>

#include "kz-window.h"

#define KZ_TYPE_NAVIGATION_ACTION            (kz_navigation_action_get_type())
#define KZ_NAVIGATION_ACTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), KZ_TYPE_NAVIGATION_ACTION, KzNavigationAction))
#define KZ_NAVIGATION_ACTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), KZ_TYPE_NAVIGATION_ACTION, KzNavigationActionClass))
#define KZ_IS_NAVIGATION_ACTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), KZ_TYPE_NAVIGATION_ACTION))
#define KZ_IS_NAVIGATION_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((obj), KZ_TYPE_NAVIGATION_ACTION))
#define KZ_NAVIGATION_ACTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), KZ_TYPE_NAVIGATION_ACTION, KzNavigationActionClass))

typedef struct _KzNavigationAction      KzNavigationAction;
typedef struct _KzNavigationActionClass KzNavigationActionClass;

struct _KzNavigationAction
{
	GtkAction   parent;

	KzWindow   *kz;
};

struct _KzNavigationActionClass
{
	GtkActionClass parent_class;
};

GType               kz_navigation_action_get_type (void);

#endif /* KZ_NAVIGATION_ACTION_H */
