/*
 *  Copyright (C) 2003 Takuro Ashie <ashie@homa.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  Based on Epiphany's code.
 *  Copyright (C) 2001 Philip Langdale
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <glib/gi18n.h>
#include <nsCOMPtr.h>
#include <nsString.h>
#include <nsIURI.h>
#include <nsIURL.h>
#include <nsIMIMEInfo.h>

#include "kz-mozlauncher.h"
#include "kz-mozfilepicker.h"


NS_IMPL_ISUPPORTS1(KzContentHandler, nsIHelperAppLauncherDialog)


KzContentHandler::KzContentHandler() :
	mUri(nsnull),
	mMimeType(nsnull),
	mDownloadCanceled(PR_FALSE)
{
	NS_INIT_ISUPPORTS();
}

KzContentHandler::~KzContentHandler()
{
	nsMemory::Free (mMimeType);
}


NS_IMETHODIMP KzContentHandler::Show(nsIHelperAppLauncher *aLauncher,
				     nsISupports *aContext,
				     PRBool aForced)
{
	nsresult rv;

	mLauncher = aLauncher;
	mContext = aContext;

	rv = Init();
	
	mLauncher->SaveToDisk(nsnull, PR_FALSE);

	return NS_OK;
}

NS_IMETHODIMP KzContentHandler::PromptForSaveToFile(
				    nsIHelperAppLauncher *aLauncher,
				    nsISupports *aWindowContext,
				    const PRUnichar *aDefaultFile,
				    const PRUnichar *aSuggestedFileExtension,
				    nsILocalFile **_retval)
{
	nsresult rv;

	mContext = aWindowContext;

	nsCOMPtr<nsIDOMWindowInternal> windowInternal = 
					do_QueryInterface(aWindowContext);
	
	nsCOMPtr<nsILocalFile> saveDir;
	static char *dirName = NULL;
	
	if (!dirName)
		dirName = g_strdup(g_get_home_dir());

	saveDir = do_CreateInstance(NS_LOCAL_FILE_CONTRACTID);
	saveDir->InitWithPath(NS_ConvertUTF8toUCS2(dirName));

	nsCOMPtr <nsILocalFile> saveFile(do_CreateInstance(NS_LOCAL_FILE_CONTRACTID));

	PRInt16 okToSave = nsIFilePicker::returnCancel;

	nsCOMPtr<nsIFilePicker> filePicker =
				do_CreateInstance(KZ_FILEPICKER_CONTRACTID);

	const nsAString &title = NS_ConvertUTF8toUCS2(_("Select the destination filename"));

#if MOZILLA_SNAPSHOT > 15
	filePicker->Init(windowInternal,
			 title, 
			 nsIFilePicker::modeSave);
	nsAutoString defaultFile(aDefaultFile);
	filePicker->SetDefaultString(defaultFile);
#else
	filePicker->Init(windowInternal,
			 PromiseFlatString(title).get(), 
			 nsIFilePicker::modeSave);
	filePicker->SetDefaultString(aDefaultFile);
#endif
	filePicker->SetDisplayDirectory(saveDir);

	filePicker->Show(&okToSave);

	if (okToSave == nsIFilePicker::returnOK)
	{
		filePicker->GetFile(getter_AddRefs(saveFile));

		nsString uFileName;
		saveFile->GetPath(uFileName);
		const nsCString &aFileName = NS_ConvertUCS2toUTF8(uFileName);

		g_free(dirName);
		dirName = g_path_get_dirname(aFileName.get());

		nsCOMPtr<nsIFile> directory;
		rv = saveFile->GetParent(getter_AddRefs(directory));

		NS_IF_ADDREF(*_retval = saveFile);

		return NS_OK;
	}

	return NS_ERROR_FAILURE;
}


NS_METHOD KzContentHandler::Init (void)
{
	nsresult rv;

	nsCOMPtr<nsIMIMEInfo> MIMEInfo;
	rv = mLauncher->GetMIMEInfo(getter_AddRefs(MIMEInfo));
#if MOZILLA_SNAPSHOT < 15
	rv = MIMEInfo->GetMIMEType(&mMimeType);
#endif

	rv = mLauncher->GetSource(getter_AddRefs(mUri));
	rv = mLauncher->GetTargetFile(getter_AddRefs(mTempFile));
	
	rv = mUri->GetSpec(mUrl);
	rv = mUri->GetScheme(mScheme);

	return NS_OK;
}
