/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-mozutils.h"

#include <nsIWindowWatcher.h>
#include <nsIWebBrowserChrome.h>
#include <nsIEmbeddingSiteWindow.h>
#include <nsCOMPtr.h>
#include <nsIServiceManager.h>


/*
 * this codes was taken from embedding/browser/gtk/src/GtkPromptService.cpp 
 * in Mozilla-1.7.3.
 *
 */
GtkWidget *
GetGtkWindowForDOMWindow(nsIDOMWindow* aDOMWindow)
{
	nsCOMPtr<nsIWindowWatcher> wwatch = do_GetService("@mozilla.org/embedcomp/window-watcher;1");

	if (!aDOMWindow)
		return NULL;

	nsCOMPtr<nsIWebBrowserChrome> chrome;
	wwatch->GetChromeForWindow(aDOMWindow, getter_AddRefs(chrome));
	nsCOMPtr<nsIEmbeddingSiteWindow> siteWindow = do_QueryInterface(chrome);

	if (!siteWindow)
		return NULL;

	GtkWidget* parentWidget;
	siteWindow->GetSiteWindow((void**)&parentWidget);

	if (!parentWidget)
		return NULL;

	GtkWidget* gtkWin = gtk_widget_get_toplevel(parentWidget);
	if (GTK_WIDGET_TOPLEVEL(gtkWin))
		return gtkWin;

	return NULL;
}

