/* -*- c-file-style: "ruby"; indent-tabs-mode: nil -*- */

/*
 *  Copyright (C) 2006 Kouhei Sutou <kou@cozmixng.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copyED of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-rb-ext.h"
#include "kz-bookmark.h"

#define _SELF(obj) (KZ_BOOKMARK(RVAL2GOBJ(obj)))

static VALUE
rb_kz_bookmark_is_editable(VALUE self)
{
    return CBOOL2RVAL(kz_bookmark_is_editable(_SELF(self)));
}

static VALUE
rb_kz_bookmark_is_separator(VALUE self)
{
    return CBOOL2RVAL(kz_bookmark_is_separator(_SELF(self)));
}

static VALUE
rb_kz_bookmark_is_folder(VALUE self)
{
    return CBOOL2RVAL(kz_bookmark_is_folder(_SELF(self)));
}

static VALUE
rb_kz_bookmark_is_pure_folder(VALUE self)
{
    return CBOOL2RVAL(kz_bookmark_is_pure_folder(_SELF(self)));
}

static VALUE
rb_kz_bookmark_get_folded(VALUE self)
{
    return CBOOL2RVAL(kz_bookmark_get_folded(_SELF(self)));
}

static VALUE
rb_kz_bookmark_set_folded(VALUE self, VALUE folded)
{
    kz_bookmark_set_folded(_SELF(self), RVAL2CBOOL(folded));
    return Qnil;
}

static VALUE
rb_kz_bookmark_insert_before(VALUE self, VALUE child, VALUE sibling)
{
    kz_bookmark_insert_before(_SELF(self), _SELF(child), _SELF(sibling));
    return Qnil;
}

static VALUE
rb_kz_bookmark_append(VALUE self, VALUE child)
{
    kz_bookmark_append(_SELF(self), _SELF(child));
    return Qnil;
}

static VALUE
rb_kz_bookmark_prepend(VALUE self, VALUE child)
{
    kz_bookmark_prepend(_SELF(self), _SELF(child));
    return Qnil;
}

static VALUE
rb_kz_bookmark_remove(VALUE self, VALUE child)
{
    kz_bookmark_remove(_SELF(self), _SELF(child));
    return Qnil;
}

static VALUE
rb_kz_bookmark_remove_all(VALUE self)
{
    kz_bookmark_remove_all(_SELF(self));
    return Qnil;
}

static VALUE
rb_kz_bookmark_get_parent(VALUE self)
{
    return GOBJ2RVAL(kz_bookmark_get_parent(_SELF(self)));
}

static VALUE
rb_kz_bookmark_get_parent_file(VALUE self)
{
    return GOBJ2RVAL(kz_bookmark_get_parent_file(_SELF(self)));
}

static VALUE
rb_kz_bookmark_get_children(VALUE self)
{
    return GLIST2ARY(kz_bookmark_get_children(_SELF(self)));
}

static VALUE
rb_kz_bookmark_has_children(VALUE self)
{
    return CBOOL2RVAL(kz_bookmark_has_children(_SELF(self)));
}

static VALUE
rb_kz_bookmark_next(VALUE self)
{
    return GOBJ2RVAL(kz_bookmark_next(_SELF(self)));
}

static VALUE
rb_kz_bookmark_prev(VALUE self)
{
    return GOBJ2RVAL(kz_bookmark_prev(_SELF(self)));
}

static VALUE
rb_kz_bookmark_sort(VALUE self, VALUE type)
{
    kz_bookmark_sort(_SELF(self), RVAL2CSTR(type));
    return Qnil;
}

static VALUE
rb_kz_bookmark_get_current(VALUE self)
{
    return UINT2NUM(kz_bookmark_get_current(_SELF(self)));
}

static VALUE
rb_kz_bookmark_set_current(VALUE self, VALUE pos)
{
    kz_bookmark_set_current(_SELF(self), NUM2UINT(pos));
    return Qnil;
}

static VALUE
rb_kz_bookmark_get_lock(VALUE self)
{
    return CBOOL2RVAL(kz_bookmark_get_lock(_SELF(self)));
}

static VALUE
rb_kz_bookmark_set_lock(VALUE self, VALUE lock)
{
    kz_bookmark_set_lock(_SELF(self), RVAL2CBOOL(lock));
    return Qnil;
}

static VALUE
rb_kz_bookmark_get_auto_refresh(VALUE self)
{
    return CBOOL2RVAL(kz_bookmark_get_auto_refresh(_SELF(self)));
}

static VALUE
rb_kz_bookmark_set_auto_refresh(VALUE self, VALUE auto_refresh)
{
    kz_bookmark_set_auto_refresh(_SELF(self), RVAL2CBOOL(auto_refresh));
    return Qnil;
}

static VALUE
rb_kz_bookmark_get_javascript(VALUE self)
{
    return CBOOL2RVAL(kz_bookmark_get_javascript(_SELF(self)));
}

static VALUE
rb_kz_bookmark_set_javascript(VALUE self, VALUE javascript)
{
    kz_bookmark_set_javascript(_SELF(self), RVAL2CBOOL(javascript));
    return Qnil;
}

static VALUE
rb_kz_bookmark_find_bookmark_from_uri(VALUE self, VALUE key_uri)
{
    return GOBJ2RVAL(kz_bookmark_find_bookmark_from_uri(_SELF(self),
                                                        RVAL2CSTR(key_uri)));
}

void
Init_kz_rb_bookmark(VALUE mKz)
{
    VALUE cKzBookmark;

    cKzBookmark = G_DEF_CLASS(KZ_TYPE_BOOKMARK, "Bookmark", mKz);

    rb_define_const(cKzBookmark, "SORT_LAST_MODIFIED",
                    CSTR2RVAL(KZ_BOOKMARK_SORT_LAST_MODIFIED));

    rb_define_method(cKzBookmark, "editable?", rb_kz_bookmark_is_editable, 0);
    rb_define_method(cKzBookmark, "separator?", rb_kz_bookmark_is_separator, 0);
    rb_define_method(cKzBookmark, "folder?", rb_kz_bookmark_is_folder, 0);
    rb_define_method(cKzBookmark, "pure_folder?",
                     rb_kz_bookmark_is_pure_folder, 0);

    rb_define_method(cKzBookmark, "folded?", rb_kz_bookmark_get_folded, 0);
    rb_define_method(cKzBookmark, "set_folded", rb_kz_bookmark_set_folded, 1);

    rb_define_method(cKzBookmark, "insert_before",
                     rb_kz_bookmark_insert_before, 2);
    rb_define_method(cKzBookmark, "append", rb_kz_bookmark_append, 1);
    rb_define_method(cKzBookmark, "prepend", rb_kz_bookmark_prepend, 1);
    rb_define_method(cKzBookmark, "remove", rb_kz_bookmark_remove, 1);
    rb_define_method(cKzBookmark, "remove_all", rb_kz_bookmark_remove_all, 0);

    rb_define_method(cKzBookmark, "parent", rb_kz_bookmark_get_parent, 0);
    rb_define_method(cKzBookmark, "parent_file",
                     rb_kz_bookmark_get_parent_file, 0);

    rb_define_method(cKzBookmark, "children", rb_kz_bookmark_get_children, 0);
    rb_define_method(cKzBookmark, "has_children?",
                     rb_kz_bookmark_has_children, 0);
    rb_alias(cKzBookmark,
             rb_intern("have_children?"),
             rb_intern("has_children?"));

    rb_define_method(cKzBookmark, "next", rb_kz_bookmark_next, 0);
    rb_define_method(cKzBookmark, "prev", rb_kz_bookmark_prev, 0);

    rb_define_method(cKzBookmark, "sort", rb_kz_bookmark_sort, 1);

    rb_define_method(cKzBookmark, "current", rb_kz_bookmark_get_current, 0);
    rb_define_method(cKzBookmark, "set_current", rb_kz_bookmark_set_current, 1);

    rb_define_method(cKzBookmark, "lock?", rb_kz_bookmark_get_lock, 0);
    rb_define_method(cKzBookmark, "set_lock", rb_kz_bookmark_set_lock, 1);
    rb_define_method(cKzBookmark, "auto_refresh?",
                     rb_kz_bookmark_get_auto_refresh, 0);
    rb_define_method(cKzBookmark, "set_auto_refresh",
                     rb_kz_bookmark_set_auto_refresh, 1);
    rb_define_method(cKzBookmark, "javascript?",
                     rb_kz_bookmark_get_javascript, 0);
    rb_define_method(cKzBookmark, "set_javascript",
                     rb_kz_bookmark_set_javascript, 1);

    rb_define_method(cKzBookmark, "find_bookmark_from_uri",
                     rb_kz_bookmark_find_bookmark_from_uri, 1);

    G_DEF_SETTERS(cKzBookmark);
}
