/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_HISTORY_ACTION_H__
#define __KZ_HISTORY_ACTION_H__

#include <gtk/gtk.h>
#include "kz-entry-action.h"
#include "eggregex.h"

G_BEGIN_DECLS

#define KZ_TYPE_HISTORY_ACTION             (kz_history_action_get_type ())
#define KZ_HISTORY_ACTION(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_HISTORY_ACTION, KzHistoryAction))
#define KZ_HISTORY_ACTION_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_HISTORY_ACTION, KzHistoryActionClass))
#define KZ_IS_HISTORY_ACTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_HISTORY_ACTION))
#define KZ_IS_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), KZ_TYPE_HISTORY_ACTION))
#define KZ_HISTORY_ACTION_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS((obj), KZ_TYPE_HISTORY_ACTION, KzHistoryActionClass))

typedef struct _KzHistoryAction      KzHistoryAction;
typedef struct _KzHistoryActionClass KzHistoryActionClass;

struct _KzHistoryAction
{
	KzEntryAction parent;

	guint max_history;

	GtkListStore *list_store;

	GtkEntryCompletion *completion;
	EggRegex *completion_egg_regex;
	gchar* completion_previous_key;;
};

struct _KzHistoryActionClass
{
	KzEntryActionClass parent_class;

	GtkComboBox *(*get_combo_widget) (KzHistoryAction *action,
				       GtkWidget       *proxy);
	void      (*set_history)      (KzHistoryAction *action,
				       GList           *history);

	/* -- signals -- */
	void      (*history_changed)  (KzHistoryAction *action);
};

GType        kz_history_action_get_type (void) G_GNUC_CONST;

void         kz_history_action_set_history      (KzHistoryAction *action,
						 GList           *history);
GList       *kz_history_action_get_history      (KzHistoryAction *action);
void         kz_history_action_set_max_history  (KzHistoryAction *action,
						 guint            max_history);
guint        kz_history_action_get_max_history  (KzHistoryAction *action);

void         kz_history_set_completion          (KzHistoryAction *action,
						 GtkEntry *entry);
void         kz_history_unset_completion        (KzHistoryAction *action,
						 GtkEntry *entry);
void         kz_history_set_inline_completion   (KzHistoryAction *action,
						 gboolean use);

/* protected */
GtkComboBox    *kz_history_action_get_combo_widget (KzHistoryAction *action,
						 GtkWidget       *proxy);

G_END_DECLS

#endif /* __KZ_HISTORY_ACTION__ */
