/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KZ_SEARCH_H__
#define _KZ_SEARCH_H__

#include <glib-object.h>
#include <kz-bookmark.h>

G_BEGIN_DECLS

#define KZ_TYPE_SEARCH		(kz_search_get_type ())
#define KZ_SEARCH(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_SEARCH, KzSearch))
#define KZ_SEARCH_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_SEARCH, KzSearchClass))
#define KZ_IS_SEARCH(obj)	   	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_SEARCH))
#define KZ_IS_SEARCH_CLASS(klass) 	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_SEARCH))
#define KZ_SEARCH_GET_CLASS(obj)  	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_SEARCH, KzSearchClass))

typedef struct _KzSearch	KzSearch;
typedef struct _KzSearchClass	KzSearchClass;

struct _KzSearch
{
	GObject parent;
};

struct _KzSearchClass
{
	GObjectClass parent_class;

	gchar	   *(*get_search_result_html)     (KzSearch *search, const gchar *text);
	KzBookmark *(*get_search_result_bookmark) (KzSearch *search, const gchar *text);
	gboolean    (*register_document)	  (KzSearch *search,
						   const gchar *uri,
						   const gchar *title,
						   const gchar *contents,
						   GTime mtime);
	gboolean    (*unregister_document)	  (KzSearch *search, const gchar *uri);
	GPid        (*optimize_index)             (KzSearch *search);
	void        (*make_index)                 (KzSearch *search);
	gboolean    (*exist_index_dir)            (KzSearch *search);
};

GType      kz_search_get_type      (void) G_GNUC_CONST;

KzSearch *kz_search_new            (const gchar *name);

gchar      *kz_search_get_search_result_html     (KzSearch *search, const gchar *text);
KzBookmark *kz_search_get_search_result_bookmark (KzSearch *search, const gchar *text);

gboolean    kz_search_register_document  	(KzSearch *search,
						 const gchar *uri,
						 const gchar *title,
						 const gchar *contents,
						 GTime mtime);
gboolean    kz_search_unregister_document  	(KzSearch *search, const gchar *uri);
GPid        kz_search_optimize_index    	(KzSearch *search);
void        kz_search_make_index              	(KzSearch *search);
gboolean    kz_search_exist_index_dir         	(KzSearch *search);

G_END_DECLS

#endif /* _KZ_SEARCH_H__ */
