/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002-2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_WINDOW_H__
#define __KZ_WINDOW_H__

#include <gtk/gtk.h>

#include "kz-objects.h"
#include "kz-gesture.h"
#include "kz-embed-event.h"
#include "kz-embed.h"
#include "kz-popup-preview.h"
#include "kz-bookmark-folder.h"
#include "kz-notebook.h"

G_BEGIN_DECLS

#define KZ_TYPE_WINDOW			(kz_window_get_type ())
#define KZ_WINDOW(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_WINDOW, KzWindow))
#define KZ_WINDOW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_WINDOW, KzWindowClass))
#define KZ_IS_WINDOW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_WINDOW))
#define KZ_IS_WINDOW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_WINDOW))
#define KZ_WINDOW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_WINDOW, KzWindowClass))

typedef struct _KzWindowClass	KzWindowClass;

struct _KzWindow
{
	GtkWindow   parent;

	GtkWidget  *top_vbox;

	/* menu and toolbar */
	GtkWidget  *menu_box;
	GtkWidget  *feed_info;

	/* top of the window */
	GtkWidget  *bookmark_bars_area;
	GList      *bookmark_bars;

	/* middle of the window */
	GtkWidget  *pane;
	GtkWidget  *sidebar;
	GtkWidget  *notebook;

	/* bottom of the window */
	GtkWidget  *statusbar;

	/* other objects */
	GtkActionGroup *actions;
	GtkActionGroup *popup_actions;
	GtkActionGroup *tabpop_actions;
	GtkUIManager   *menu_merge;

	/* bookmarks */
	KzBookmarkFolder *tabs;
	KzBookmarkFolder *closed_tabs;
	KzBookmark *history_search;

	/* handle for favicon */
	KzPopupPreview *popup;
	GtkWidget *popup_tablist;
};

struct _KzWindowClass
{
	GtkWindowClass parent_class;

	/* -- signals -- */
	void (*append_tab)  (KzWindow  *kz,
			     GtkWidget *widget,
			     GtkWidget *parent);
	void (*remove_tab)  (KzWindow  *kz,
			     GtkWidget *widget);
	void (*reorder_tab) (KzWindow  *kz,
			     GtkWidget *widget,
			     gint       pos);
};

GType	          kz_window_get_type                 (void) G_GNUC_CONST;
GtkWidget        *kz_window_new                      (const gchar *url);
GtkWidget        *kz_window_open_new_tab             (KzWindow    *kz,
						      const gchar *url);
GtkWidget        *kz_window_open_new_tab_with_parent (KzWindow    *kz,
						      const gchar *url,
						      GtkWidget   *parent);
void              kz_window_close_tab                (KzWindow    *kz,
						      KzEmbed     *embed);
void              kz_window_close_all_tab            (KzWindow    *kz);
void		  kz_window_move_tab 		     (KzWindow    *src_kz,
						      KzWindow    *dest_kz,
						      GtkWidget   *widget);
void		  kz_window_restore_tabs	     (KzWindow    *kz,
						      KzBookmark  *tabs);
void              kz_window_load_url                 (KzWindow    *kz,
						      const gchar *url);
void              kz_window_store_state              (KzWindow    *kz);
void              kz_window_restore_state            (KzWindow    *kz);
void              kz_window_connect_action           (KzWindow    *kz,
						      GtkAction   *action);
void              kz_window_disconnect_action        (KzWindow    *kz,
						      GtkAction   *action);
void              kz_window_update_gesture_items     (KzWindow    *kz);
const gchar      *kz_window_get_title                (KzWindow    *kz);
const gchar      *kz_window_get_uri                  (KzWindow    *kz);

KzTabLabel       *kz_window_get_tab_label            (KzWindow    *kz,
						      KzEmbed     *embed);

GNode            *kz_window_get_tree                 (KzWindow    *kz);

void              kz_window_set_location_entry_text  (KzWindow    *kz,
						      const gchar *text);
gboolean          kz_window_activate_action          (KzWindow    *kz,
						      const gchar *name);
gboolean          kz_window_activate_popup_action    (KzWindow    *kz,
						      const gchar *name);
gboolean          kz_window_activate_tabpop_action   (KzWindow    *kz,
						      const gchar *name);

const KzEmbedEventMouse *
		  kz_window_get_mouse_event_info     (KzWindow    *kz);

void		  kz_window_append_closed_tab	     (KzWindow    *kz,
						      KzBookmarkFolder  *tab);
void		  kz_window_switch_layout_engine     (KzWindow    *kz,
						      const gchar *engine_name);

#define KZ_WINDOW_NTH_EMBED(kz, n) \
	(KZ_IS_WINDOW(kz) ? kz_notebook_get_nth_embed(KZ_NOTEBOOK(KZ_WINDOW(kz)->notebook),n) : NULL)
#define KZ_WINDOW_CURRENT_EMBED(kz) \
	(KZ_IS_WINDOW(kz) ? KZ_WINDOW_NTH_EMBED(kz, kz_notebook_get_current_page(KZ_NOTEBOOK(kz->notebook))) : NULL)

#define KZ_WINDOW_SET_SENSITIVE(kz, action_name, sensitive)		       \
{									       \
	if (KZ_IS_WINDOW(kz) && GTK_IS_ACTION_GROUP(kz->actions)) {	       \
		GtkAction *action;					       \
		action = gtk_action_group_get_action(kz->actions,	       \
						     action_name);	       \
		if (action) gtk_action_set_sensitive(action, sensitive);       \
	}								       \
}

#define KZ_WINDOW_SET_VISIBLE(kz, action_name, visible)			       \
{									       \
	if (KZ_IS_WINDOW(kz) && GTK_IS_ACTION_GROUP(kz->actions)) {	       \
		GtkAction *action;					       \
		action = gtk_action_group_get_action(kz->actions, 	       \
						     action_name);	       \
		if (action) gtk_action_set_visible(action, visible);           \
	}								       \
}

G_END_DECLS

#endif /* __KZ_WINDOW_H__ */
