/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2009 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-bin.h"

G_DEFINE_TYPE(KzBin, kz_bin, GTK_TYPE_BIN)

static void size_allocate (GtkWidget     *widget,
                           GtkAllocation *allocation);

static void
kz_bin_class_init (KzBinClass *klass)
{
	GtkWidgetClass *widget_class = GTK_WIDGET_CLASS(klass);

	widget_class->size_allocate = size_allocate;
}

static void
kz_bin_init (KzBin *bin)
{
}

GtkWidget *
kz_bin_new (void)
{
	return GTK_WIDGET(g_object_new(KZ_TYPE_BIN, NULL));
}

static void
size_allocate (GtkWidget *widget, GtkAllocation *allocation)
{
	GtkWidget *child;
	GtkAllocation child_allocation;

	widget->allocation = *allocation;

	if (GTK_WIDGET_NO_WINDOW(widget))
	{
		child_allocation.x = allocation->x + GTK_CONTAINER(widget)->border_width;
		child_allocation.y = allocation->y + GTK_CONTAINER(widget)->border_width;
	}
	else
	{
		child_allocation.x = 0;
		child_allocation.y = 0;
	}

	child_allocation.width = MAX(allocation->width - GTK_CONTAINER(widget)->border_width * 2, 0);
	child_allocation.height = MAX(allocation->height - GTK_CONTAINER(widget)->border_width * 2, 0);

	child = gtk_bin_get_child(GTK_BIN(widget));
	if (child)
		gtk_widget_size_allocate(child, &child_allocation);

}

void
kz_bin_change_child (KzBin *bin, GtkWidget *new_child)
{
	gtk_container_remove(GTK_CONTAINER(bin), gtk_bin_get_child(GTK_BIN(bin)));
	gtk_container_add(GTK_CONTAINER(bin), new_child);
}

