/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 *  Copyright (C) 2009 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-password-info.h"

KzPasswordInfo *
kz_password_info_new (const gchar *uri, const gchar *user_name)
{
    KzPasswordInfo *password_info;

    password_info = g_slice_new0(KzPasswordInfo);
    password_info->user_name = g_strdup(user_name);
    password_info->uri = g_strdup(uri);
    return password_info;
}

void
kz_password_info_free (KzPasswordInfo *password_info)
{
    if (!password_info)
        return;
    g_free(password_info->user_name);
    g_free(password_info->uri);
    g_slice_free(KzPasswordInfo, password_info);
}

void
kz_password_info_list_free (GList *list)
{
    if (!list)
        return;
    g_list_foreach(list, (GFunc)kz_password_info_free, NULL);
    g_list_free(list);
}

/* 
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
