/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "gobject-utils.h"
#include "kz-bookmarkbar.h"
#include "kz-rssmenu.h"
#include "utils.h"

static void kz_bookmark_bar_class_init    (KzBookmarkBarClass *klass);
static void kz_bookmark_bar_init          (KzBookmarkBar *kzbkmkbar);
static void kz_bookmark_bar_dispose       (GObject *object);

static void kz_bookmark_bar_refresh_all   (KzBookmarkBar *kzbkmkbar);

static void cb_rss_list_updated           (KzRSSList *rsslist,
					   KzBookmarkBar *kzbkmkbar);

static GtkToolbarClass *parent_class = NULL;

KZ_OBJECT_GET_TYPE(kz_bookmark_bar, "KzBookmarkBar", KzBookmarkBar,
		   kz_bookmark_bar_class_init, kz_bookmark_bar_init,
		   GTK_TYPE_TOOLBAR)

static void
kz_bookmark_bar_class_init (KzBookmarkBarClass *klass)
{
	GObjectClass *gobject_class;

	parent_class = g_type_class_peek_parent (klass);

	gobject_class = (GObjectClass *) klass;

	/* GObject class */
	gobject_class->dispose = kz_bookmark_bar_dispose;
}

static void
kz_bookmark_bar_init (KzBookmarkBar *kzbkmkbar)
{
	kzbkmkbar->parent_kazehakase = NULL;
	kzbkmkbar->rsslist = NULL;
	kzbkmkbar->children = NULL;
}

static void
kz_bookmark_bar_dispose (GObject *object)
{
	KzBookmarkBar *kzbkmkbar = KZ_BOOKMARK_BAR(object);

	kzbkmkbar->parent_kazehakase = NULL;

	if (kzbkmkbar->rsslist)
	{
		g_signal_handlers_disconnect_by_func
			(G_OBJECT(kzbkmkbar->rsslist),
			 G_CALLBACK(cb_rss_list_updated), kzbkmkbar);
		g_object_unref(kzbkmkbar->rsslist);
		kzbkmkbar->rsslist = NULL;
	}

	if (G_OBJECT_CLASS (parent_class)->dispose)
		G_OBJECT_CLASS (parent_class)->dispose(object);
}

/* create new rssbar */
GtkWidget *
kz_bookmark_bar_new (KzWindow *kz)
{
	KzBookmarkBar *kzbkmkbar
		= KZ_BOOKMARK_BAR(g_object_new(KZ_TYPE_BOOKMARK_BAR, NULL));
        gchar *toolbarfile;

	/* build the filename */
        toolbarfile = g_strconcat(g_get_home_dir(),
				  "/.kazehakase/toolbar.xml",
				  NULL);
	
	kzbkmkbar->parent_kazehakase = kz;
	kzbkmkbar->rsslist = kz_rss_list_get_instance();

	g_signal_connect(G_OBJECT(kzbkmkbar->rsslist), "updated",
			 G_CALLBACK(cb_rss_list_updated), kzbkmkbar);

	kz_bookmark_bar_refresh_all (kzbkmkbar);

	g_free(toolbarfile);

	return GTK_WIDGET(kzbkmkbar);
}

static void
kz_bookmark_bar_refresh_all (KzBookmarkBar *kzbkmkbar)
{
	GList *children;
	GSList *node;

        /*
	 * Taken from Gtk+-2.2.2 (gtk/gtktoolbar.c)
	 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
	 * GtkToolbar copyright (C) Federico Mena
	 */ 
	children = GTK_TOOLBAR(kzbkmkbar)->children;
	for (; children; children = children->next)
	{
		GtkToolbarChild *child;

		child = children->data;

		if (child->type != GTK_TOOLBAR_CHILD_SPACE)
		{
			g_object_ref (child->widget);
			gtk_widget_unparent (child->widget);
			gtk_widget_destroy (child->widget);
			g_object_unref (child->widget);
		}
		
		g_free (child);
	}
	g_list_free (GTK_TOOLBAR(kzbkmkbar)->children);
	GTK_TOOLBAR(kzbkmkbar)->children = NULL;

	for (node = kzbkmkbar->rsslist->items; node; node = g_slist_next(node))
	{
		GtkWidget *rss_menu;
		KzRSS *rss = node->data;

		rss_menu = kz_rss_menu_new(kzbkmkbar->parent_kazehakase, rss);
		gtk_toolbar_append_widget(GTK_TOOLBAR(kzbkmkbar),
					  rss_menu, NULL, NULL);
	}

	gtk_widget_queue_resize(GTK_WIDGET(kzbkmkbar));
}

static void
cb_rss_list_updated (KzRSSList *rsslist, KzBookmarkBar *kzbkmkbar)
{
	g_return_if_fail(KZ_IS_RSS_LIST(rsslist));
	g_return_if_fail(KZ_IS_BOOKMARK_BAR(kzbkmkbar));

	kz_bookmark_bar_refresh_all(kzbkmkbar);
}
