/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-icons.c 211 2003-09-18 11:42:33Z makeinu $
 */

#include "kz-icons.h"

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>

GtkIconSize KZ_ICON_SIZE_BOOKMARK_MENU = GTK_ICON_SIZE_INVALID;

void
kz_icons_init (void)
{
	GtkIconFactory *factory;
	static gchar *dirname = NULL;
	DIR *dp;
	struct dirent *entry;

	if (!dirname)
		dirname = g_strconcat(DATADIR, "/icons", NULL);

	dp = opendir(dirname);
	if (!dp) return;

	factory = gtk_icon_factory_new();
	gtk_icon_factory_add_default(factory);

	/*
	 * regist our icon size definitions
	 */
	KZ_ICON_SIZE_BOOKMARK_MENU
		= gtk_icon_size_register("KZ_ICON_SIZE_BOOKMARK_MENU",
					 12, 12);

	/*
	 * regist our icons
	 */
	while ((entry = readdir(dp)))
	{
		GtkIconSet *icon_set;
		GdkPixbuf *pixbuf;
		gchar *filename, icon_name[256];
		gint len, namelen;

		len = strlen(entry->d_name);
		if (len <= 4 || strcasecmp(entry->d_name + len - 4, ".xpm"))
			continue;

		/* build icon name */
		namelen = len - 4 < sizeof(icon_name)
			? len - 4 : sizeof(icon_name) - 1;
		memcpy(icon_name, entry->d_name, namelen);
		icon_name[namelen] = '\0';

		/* load icon file */
		filename = g_strconcat(dirname, "/", entry->d_name, NULL);
		pixbuf = gdk_pixbuf_new_from_file(filename, NULL);
		g_free (filename);

		if (!pixbuf) continue;

		/* store to the global icon stock */
		icon_set = gtk_icon_set_new_from_pixbuf(pixbuf);
		gtk_icon_factory_add(factory, icon_name, icon_set);
		gtk_icon_set_unref(icon_set);

		g_object_unref(G_OBJECT(pixbuf));
	}

	g_object_unref(G_OBJECT (factory));

	closedir(dp);
}
