/*
 *  Copyright (C) 2006 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "rendako.h"
#include "rd-open-search.h"
#include "GeckoContentHandler.h"
#include "GeckoPrivate.h"
#include "rd-marshalers.h"
#include <nsCOMPtr.h>
#include <nsIURI.h>
#include <nsISAXXMLReader.h>
#define MOZILLA_INTERNAL_API
#include <nsIComponentManager.h>
#include <nsICanvasRenderingContextInternal.h>
#include <nsNetUtil.h>
#undef MOZILLA_INTERNAL_API

#include <glib/gi18n.h>

typedef struct _RdOpenSearchPrivate RdOpenSearchPrivate;
struct _RdOpenSearchPrivate
{
};

#define RD_OPEN_SEARCH_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), RD_TYPE_OPEN_SEARCH, RdOpenSearchPrivate))

enum {
	LINK_SIGNAL,
	DESCRIPTION_SIGNAL,
	LAST_SIGNAL
};

static gint rd_open_search_signals[LAST_SIGNAL] = {0};

static void     rd_open_search_class_init     (RdOpenSearchClass *klass);
static void     rd_open_search_init           (RdOpenSearch      *open_search);
static void     rd_open_search_dispose        (GObject            *object);
static void     rd_open_search_finalize       (GObject            *object);

static GObjectClass *parent_class = NULL;

G_DEFINE_TYPE (RdOpenSearch, rd_open_search, G_TYPE_OBJECT)

static void
rd_open_search_class_init (RdOpenSearchClass *klass)
{
	GObjectClass *gobject_class;

	parent_class = (GObjectClass *) g_type_class_peek_parent (klass);

	gobject_class = (GObjectClass *)   klass;
  
	gobject_class->dispose  = rd_open_search_dispose;
	gobject_class->finalize = rd_open_search_finalize;

	klass->link = NULL;

	rd_open_search_signals[LINK_SIGNAL]
		= g_signal_new ("link",
				G_TYPE_FROM_CLASS (klass),
				(GSignalFlags) (G_SIGNAL_RUN_LAST),
				G_STRUCT_OFFSET (RdOpenSearchClass, link),
				NULL, NULL,
				g_cclosure_marshal_VOID__STRING,
				G_TYPE_NONE, 1,
				G_TYPE_STRING);

	rd_open_search_signals[DESCRIPTION_SIGNAL]
		= g_signal_new ("description",
				G_TYPE_FROM_CLASS (klass),
				(GSignalFlags) (G_SIGNAL_RUN_LAST),
				G_STRUCT_OFFSET (RdOpenSearchClass, link),
				NULL, NULL,
				_rd_marshal_VOID__STRING_STRING,
				G_TYPE_NONE, 2,
				G_TYPE_STRING,
				G_TYPE_STRING);

	g_type_class_add_private (gobject_class, sizeof(RdOpenSearchPrivate));
}

static void
rd_open_search_init (RdOpenSearch *open_search)
{
	RdOpenSearchPrivate *priv = RD_OPEN_SEARCH_GET_PRIVATE (open_search);
}

static void
rd_open_search_dispose (GObject *object)
{
	RdOpenSearchPrivate *priv = RD_OPEN_SEARCH_GET_PRIVATE (object);

	if (G_OBJECT_CLASS(parent_class)->dispose)	
		G_OBJECT_CLASS (parent_class)->dispose (object);
}

static void
rd_open_search_finalize (GObject *object)
{
	if (G_OBJECT_CLASS(parent_class)->finalize)
		G_OBJECT_CLASS (parent_class)->finalize (object);
}

RdOpenSearch *
rd_open_search_new (void)
{
	RdOpenSearch *open_search;

	open_search = RD_OPEN_SEARCH (g_object_new (RD_TYPE_OPEN_SEARCH, NULL));

	return open_search;
}

void
rd_open_search_keyword (RdOpenSearch *os, const gchar *keyword)
{
	nsresult rv;

	nsCOMPtr<nsIURI> uri;

	GeckoPrivate::NewURI (getter_AddRefs(uri), keyword);

	nsCOMPtr<nsISAXXMLReader> reader;
	reader = do_CreateInstance ("@mozilla.org/saxparser/xmlreader;1");
	reader->ParseAsync (nsnull);

	GeckoContentHandler *handler = new GeckoContentHandler;
	handler->Init (os);
	reader->SetContentHandler (handler);

	rv = NS_OpenURI (reader, nsnull, uri);
}

