/*
 *  Copyright (C) 2006 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __RD_IMAGE_H__
#define __RD_IMAGE_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define RD_TYPE_IMAGE            (rd_image_get_type ())
#define RD_IMAGE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), RD_TYPE_IMAGE, RdImage))
#define RD_IMAGE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), RD_TYPE_IMAGE, RdImageClass))
#define RD_IS_IMAGE(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RD_TYPE_IMAGE))
#define RD_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RD_TYPE_IMAGE))
#define RD_IMAGE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), RD_TYPE_IMAGE, RdImageClass))

typedef struct _RdImage		RdImage;
typedef struct _RdImageClass	RdImageClass;

struct _RdImage
{
	GtkWidget  parent;
};

struct _RdImageClass
{
	GtkWidgetClass parent_class;
};

GtkType	          rd_image_get_type  (void);

GtkWidget        *rd_image_new       (void);

void		  rd_image_set_cairo_surface (RdImage *image, cairo_surface_t *cs);

void		  rd_image_set_size          (RdImage *image, gint width, gint height);

G_END_DECLS

#endif /* __RD_IMAGE_H__ */
