/*
 *  Copyright (C) 2006 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __RD_WINDOW_H__
#define __RD_WINDOW_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define RD_TYPE_WINDOW            (rd_window_get_type ())
#define RD_WINDOW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), RD_TYPE_WINDOW, RdWindow))
#define RD_WINDOW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), RD_TYPE_WINDOW, RdWindowClass))
#define RD_IS_WINDOW(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RD_TYPE_WINDOW))
#define RD_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RD_TYPE_WINDOW))
#define RD_WINDOW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), RD_TYPE_WINDOW, RdWindowClass))

typedef struct _RdWindow	RdWindow;
typedef struct _RdWindowClass	RdWindowClass;

struct _RdWindow
{
	GtkWindow  parent;
	GtkWidget *canvas;
};

struct _RdWindowClass
{
	GtkWindowClass parent_class;
};

GtkType	          rd_window_get_type  (void);

GtkWidget        *rd_window_new       (void);

void		  rd_window_load_uri  (RdWindow *window, const gchar *uri);

G_END_DECLS

#endif /* __RD_WINDOW_H__ */
