package jp.kirikiri.tjs2;

public class ExceptionClass extends NativeClass {

	static public int mClassID = -1;
	static private final String CLASS_NAME = "Exception";

	public ExceptionClass() throws VariantException, TJSException {
		super(CLASS_NAME);
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
				Variant val = new Variant("");
				if( (param.length > 0) ? param[0].isVoid() != true : false ) {
					val.copyRef( param[0] );
				}

				final String message_name = "message";
				objthis.propSet( Interface.MEMBERENSURE, message_name, val, objthis );

				if( (param.length > 1) ? param[1].isVoid() != true : false ) {
					val.copyRef( param[1] );
				} else {
					val.set( "" );
				}

				final String trace_name = "trace";
				objthis.propSet( Interface.MEMBERENSURE, trace_name, val, objthis);
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, 0 );

		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return Error.S_OK;
			}
		}, CLASS_NAME, Interface.nitMethod, 0 );
	}
}
