package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.TJSException;

public class SimpleImageProviderObject implements SimpleImageProvider {
	@Override
	public ScanLineProvider loadImage( final String name, int bpp, int key, int w, int h ) {

		if(bpp != 8 && bpp != 32) return null; // invalid bitmap color depth

		BaseBitmap bitmap = new BaseBitmap(TempBitmapHolder.get()); //(TVPGetInitialBitmap());

		try {
			GraphicsLoader.loadGraphic( bitmap, name, key, w, h, bpp == 8 ? GraphicsLoader.glmGrayscale : GraphicsLoader.glmNormal, null, null );
		} catch (TJSException e) {
			bitmap = null;
			return null;
		}

		ScanLineProvider scpro = new ScanLineProviderForBaseBitmap(bitmap, true);
		return scpro;
	}

}
