/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 *  software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏
 * ꍇɌAĔЕzюgp܂B
 *
 * E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐ
 *   ܂߂邱ƁB
 * EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL
 *   쌠\A{ꗗAщLƐӏ܂߂邱ƁB
 * Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔
 *   iɁAgD̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
 *
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v
 * ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂K
 * ɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂
 * B쌠҂Rgr[^[AR̂킸AQ̌
 * 킸AӔC̍_ł邩iӔCł邩iߎ̑́js@
 * sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂ
 * ĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BA
 * gp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳
 * jڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQ
 * āAؐӔC𕉂Ȃ̂Ƃ܂B
 ******************************************************************************
 * {\tgEFÁAgg2 ( http://kikyou.info/tvp/ ) ̃\[XR[hJava
 * ɏ̂ꕔgpĂ܂B
 * gg2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tjs2;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MessageMapper {
	static public class MessageHolder {
		final String mName;
		final String mDefaultMessage;
		String mAssignedMessage;

		public MessageHolder( final String name, final String defmsg ) {
			//mAssignedMessage = null;
			mDefaultMessage = defmsg;
			mName = name;
			TJS.registerMessageMap(mName, this);
		}

		public MessageHolder( final String name, final String defmsg, boolean regist ) {
			/* "name" and "defmsg" must point static area */
			//mAssignedMessage = null;
			mDefaultMessage = defmsg;
			if( regist ) {
				mName = name;
				TJS.registerMessageMap(mName, this);
			} else {
				mName = null;
			}
		}

		protected void finalize() {
			if(mName!=null) TJS.unregisterMessageMap(mName);
			if(mAssignedMessage!=null) mAssignedMessage = null;
		}

		public void assignMessage( final String msg ) {
			if(mAssignedMessage!=null) mAssignedMessage = null;
			mAssignedMessage = msg;
		}
		public String getMessage() {
			 return mAssignedMessage != null ? mAssignedMessage : mDefaultMessage;
		}
	}

	HashMap<String, MessageHolder> mHash;


	public MessageMapper() {
		mHash = new HashMap<String, MessageHolder>();
	}

	public void register( final String name, MessageHolder holder ) {
		mHash.put( name, holder);
	}

	public void unregister( final String name ) {
		mHash.remove(name);
	}

	public boolean assignMessage( final String name, final String newmsg ) {
		MessageHolder holder = mHash.get(name);
		if(holder!=null) {
			holder.assignMessage(newmsg);
			return true;
		}
		return false;
	}

	public String get( final String name ) {
		MessageHolder holder = mHash.get(name);
		if(holder!=null) {
			return holder.getMessage();
		}
		return null;
	}

	@SuppressWarnings("rawtypes")
	public String createMessageMapString() {
		StringBuilder script = new StringBuilder();
		Collection ite = mHash.entrySet();
		for( Iterator i = ite.iterator(); i.hasNext(); ) {
		    Map.Entry entry = (Map.Entry)i.next();
		    String name = (String)entry.getKey();

			MessageHolder h = (MessageHolder)entry.getValue();
			script.append("\tr(\"");
			script.append(  LexBase.escapeC(name) );
			script.append("\", \"");
			script.append( LexBase.escapeC(h.getMessage()) );
			script.append("\");\n");
		}
		return script.toString();
	}
}
