package jp.kirikiri.tjs2;

import java.nio.ByteBuffer;

public class RandomGeneratorNI extends NativeInstanceObject {
	static private RandomBits128 mRandomBits128 = null;
	static public void setRandomBits128( RandomBits128 rbit128 ) {
		mRandomBits128 = rbit128;
	}


	private static final int MT_N = 624;
	private static final int
		MEMBERENSURE		= 0x00000200, // create a member if not exists
		MEMBERMUSTEXIST     = 0x00000400, // member *must* exist ( for Dictionary/Array )
		IGNOREPROP			= 0x00000800, // ignore property invoking
		HIDDENMEMBER		= 0x00001000, // member is hidden
		STATICMEMBER		= 0x00010000, // member is not registered to the
										  // object (internal use)
		ENUM_NO_VALUE		= 0x00100000; // values are not retrieved
										  // (for EnumMembers)

	private MersenneTwister mGenerator;

	public RandomGeneratorNI() {
		super();
		mGenerator = null;
	}
	protected void finalize() {
		mGenerator = null;
		try {
			super.finalize();
		} catch (Throwable e) {
		}
	}

	public Dispatch2 serialize() throws VariantException, TJSException {
		// create dictionary object which has reconstructible information
		// which can be passed into constructor or randomize method.
		if( mGenerator == null ) return null;

		Dispatch2 dic = null;
		Variant val = new Variant();

		// retrive tTJSMersenneTwisterData
		final MersenneTwisterData data = mGenerator.getData();
		// create 'state' string
		String state;
		StringBuilder p = new StringBuilder(MT_N * 8);
		for( int i = 0; i < MT_N; i++ ) {
			final String hex = "0123456789abcdef";
			p.append( hex.charAt( (int) ((data.state.get(i)  >> 28) & 0x000f) ) );
			p.append( hex.charAt( (int) ((data.state.get(i)  >> 24) & 0x000f) ) );
			p.append( hex.charAt( (int) ((data.state.get(i)  >> 20) & 0x000f) ) );
			p.append( hex.charAt( (int) ((data.state.get(i)  >> 16) & 0x000f) ) );
			p.append( hex.charAt( (int) ((data.state.get(i)  >> 12) & 0x000f) ) );
			p.append( hex.charAt( (int) ((data.state.get(i)  >>  8) & 0x000f) ) );
			p.append( hex.charAt( (int) ((data.state.get(i)  >>  4) & 0x000f) ) );
			p.append( hex.charAt( (int) ((data.state.get(i)  >>  0) & 0x000f) ) );
		}
		state = p.toString();

		// create dictionary and store information
		dic = TJS.createDictionaryObject();

		val.set( state );
		dic.propSet(MEMBERENSURE, "state", val, dic);

		val.set( data.left );
		dic.propSet(MEMBERENSURE, "left", val, dic);

		val.set( data.next );
		dic.propSet(MEMBERENSURE, "next", val, dic);
		return dic;
	}

	public void randomize( Variant[] param ) throws TJSException, VariantException {
		if( param.length == 0 ) {
			// parametor not given
			if( mRandomBits128 != null ) {
				// another random generator is given
				//tjs_uint8 buf[32];
				//unsigned long tmp[32];
				ByteBuffer buf = ByteBuffer.allocateDirect(32);
				mRandomBits128.getRandomBits128( buf, 0 );
				mRandomBits128.getRandomBits128( buf, 16 );
				int[] tmp = new int[32];

				for( int i = 0; i < 32; i++) {
					long num = (long)buf.get(i) + ((long)buf.get(i) << 8) + ((long)buf.get(1) << 16) + ((long)buf.get(i) << 24);
					tmp[i] = (int) (num > Integer.MAX_VALUE ? num - 0x100000000L : num);
				}
				if( mGenerator != null ) mGenerator = null;
				mGenerator = new MersenneTwister(tmp);
			} else {
				if( mGenerator != null ) mGenerator = null;
				mGenerator = new MersenneTwister( System.currentTimeMillis() );
			}
		} else if( param.length >= 1 ) {
			if( param[0].isObject() ) {
				MersenneTwisterData data = null;
				try {
					// may be a reconstructible information
					VariantClosure clo = param[0].asObjectClosure();
					if( clo.mObject == null ) throw new TJSException( Error.NullAccess );

					String state;
					Variant val = new Variant();
					data = new MersenneTwisterData();

					// get state array
					//TJSThrowFrom_tjs_error
					int hr = clo.propGet(MEMBERMUSTEXIST, "state", val, null );
					if( hr < 0 ) InterCodeContext.throwFrom_tjs_error( hr, null );

					state = val.asString();
					if( state.length() != MT_N * 8) {
						throw new TJSException( Error.NotReconstructiveRandomizeData );
					}

					int p = 0;
					for( int i = 0; i < MT_N; i++) {
						long n = 0;
						int tmp;
						for( int j = 0; j < 8; j++ ) {
							int c = state.charAt(p+j);
							tmp = -1;
							if(c >= '0' && c <= '9') n = c - '0';
							else if(c >= 'a' && c <= 'f') n = c - 'a' + 10;
							else if(c >= 'A' && c <= 'F') n = c - 'A' + 10;

							if(tmp == -1) {
								throw new TJSException( Error.NotReconstructiveRandomizeData );
							} else {
								n <<= 4;
								n += tmp;
							}
						}
						p += 8;
						data.state.put( i, n&0xffffffffL );
					}

					// get other members
					hr = clo.propGet(MEMBERMUSTEXIST, "left", val, null );
					if( hr < 0 ) InterCodeContext.throwFrom_tjs_error( hr, null );

					data.left = val.asInteger();

					hr = clo.propGet( MEMBERMUSTEXIST, "next", val, null  );
					data.next = val.asInteger();

					if( mGenerator != null ) mGenerator = null;
					mGenerator = new MersenneTwister(data);
				} catch( VariantException e ) {
					data = null;
					throw new TJSException( Error.NotReconstructiveRandomizeData );
				} catch( TJSException e ) {
					data = null;
					throw new TJSException( Error.NotReconstructiveRandomizeData );
				}
				data = null;
			} else {
				// 64bitじゃなくて、32bit にしてしまっている。実用上問題あれば修正。
				int n = param[0].asInteger();
				int[] tmp = new int[1];
				tmp[0] = n;
	  			if( mGenerator != null ) mGenerator = null;
	  			mGenerator = new MersenneTwister(tmp);
			}
		}
	}
	public double random() {
		// returns double precision random value x, x is in 0 <= x < 1
		if( mGenerator == null) return 0;
		return mGenerator.rand_double();

	}
	public int random32() {
		// returns 63 bit integer random value
		if( mGenerator == null ) return 0;
		return mGenerator.int32();
	}
	public long random63() {
		// returns 63 bit integer random value
		if( mGenerator == null ) return 0;

		long v;
		v = (long)mGenerator.int32() << 32;
		v |= mGenerator.int32();

		return v & 0x7fffffffffffffffL;
	}
	public long random64() {
		// returns 64 bit integer random value
		if( mGenerator == null ) return 0;

		long v;
		v = (long)mGenerator.int32() << 32;
		v |= mGenerator.int32();

		return v;
	}
}
