package jp.kirikiri.tvp2.env;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;

import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.base.ByteBufferInputStream;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;

public class MouseCursor {
	static public final int
	crDefault = 0x0,
	crNone = -1,
	crArrow = -2,
	crCross = -3,
	crIBeam = -4,
	crSize = -5,
	crSizeNESW = -6,
	crSizeNS = -7,
	crSizeNWSE = -8,
	crSizeWE = -9,
	crUpArrow = -10,
	crHourGlass = -11,
	crDrag = -12,
	crNoDrop = -13,
	crHSplit = -14,
	crVSplit = -15,
	crMultiDrag = -16,
	crSQLWait = -17,
	crNo = -18,
	crAppStart = -19,
	crHelp = -20,
	crHandPoint = -21,
	crSizeAll = -22,
	crHBeam = 1;

	private HashMap<String, Integer> mCursorTable;
	private int mCursorCount;
	private ArrayList<Cursor> mCursors;

	private HashMap<Integer, Cursor> mInternalCursor;
	public MouseCursor() {
		mCursorTable = new HashMap<String,Integer>();
		mCursorCount = 1;
		mCursors = new ArrayList<Cursor>();
		mCursors.add(null);

		mInternalCursor = new HashMap<Integer, Cursor>();
		mInternalCursor.put( crDefault, Cursor.getDefaultCursor() );
		mInternalCursor.put( crArrow, Cursor.getDefaultCursor() );
		mInternalCursor.put( crCross, Cursor.getPredefinedCursor( Cursor.CROSSHAIR_CURSOR ) );
		mInternalCursor.put( crIBeam, Cursor.getPredefinedCursor( Cursor.TEXT_CURSOR ) );
		mInternalCursor.put( crHourGlass, Cursor.getPredefinedCursor( Cursor.WAIT_CURSOR ) );
		mInternalCursor.put( -30, Cursor.getPredefinedCursor( Cursor.SW_RESIZE_CURSOR ) );
		mInternalCursor.put( -31, Cursor.getPredefinedCursor( Cursor.SE_RESIZE_CURSOR ) );
		mInternalCursor.put( -32, Cursor.getPredefinedCursor( Cursor.NW_RESIZE_CURSOR ) );
		mInternalCursor.put( -33, Cursor.getPredefinedCursor( Cursor.NE_RESIZE_CURSOR ) );
		mInternalCursor.put( crUpArrow, Cursor.getPredefinedCursor( Cursor.N_RESIZE_CURSOR ) );
		mInternalCursor.put( -34, Cursor.getPredefinedCursor( Cursor.S_RESIZE_CURSOR ) );
		mInternalCursor.put( -35, Cursor.getPredefinedCursor( Cursor.W_RESIZE_CURSOR ) );
		mInternalCursor.put( -36, Cursor.getPredefinedCursor( Cursor.E_RESIZE_CURSOR ) );
		mInternalCursor.put( crHandPoint, Cursor.getPredefinedCursor( Cursor.HAND_CURSOR ) );
		mInternalCursor.put( crSize, Cursor.getPredefinedCursor( Cursor.MOVE_CURSOR ) );

		BufferedImage image = new BufferedImage(32, 32, BufferedImage.TYPE_4BYTE_ABGR);
		Cursor c = Toolkit.getDefaultToolkit().createCustomCursor( image, new Point(16,16),"trans");
		mInternalCursor.put( crNone, c );

		// 未定義のカーソル画像をどうするか……
		//Toolkit.getDefaultToolkit()
	}
	public Cursor getCursor( int v ) {
		Cursor c = mInternalCursor.get(v);
		if( c != null ) {
			return c;
		} else {
			return null;
		}
	}
	public int getCursor( WindowForm win, final String name ) throws TJSException {
		// get placed path
		String place = Storage.searchPlacedPath(name);

		// search in cache
		Integer in_hash = mCursorTable.get(place);
		if(in_hash!=null) return in_hash.intValue();

		// not found
		BinaryStream stream = Storage.createStream(place,0);
		long size = stream.getSize();
		ByteBuffer buff = ByteBuffer.allocateDirect((int)size);
		stream.read(buff);
		stream.close();
		buff.flip();
		ByteBufferInputStream input = new ByteBufferInputStream(buff);
		BufferedImage img = NativeImageLoader.loadImage(input);
		if( img == null ) Message.throwExceptionMessage(Message.CannotLoadCursor, place);

		Cursor c = win.getToolkit().createCustomCursor( img, new Point(img.getWidth()/2,img.getHeight()/2), name );

		mCursorCount++;
		mCursors.add( mCursorCount, c);
		mCursorTable.put(place, mCursorCount);
		mInternalCursor.put( mCursorCount, c );
		return mCursorCount;
	}
}
