package jp.kirikiri.tvp2.utils;

import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.NativeClass;
import jp.kirikiri.tjs2.NativeClassConstructor;
import jp.kirikiri.tjs2.NativeClassMethod;
import jp.kirikiri.tjs2.NativeClassProperty;
import jp.kirikiri.tjs2.NativeInstance;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.EventManager;
import jp.kirikiri.tvp2.env.TimerThread;

public class TimerClass extends NativeClass {

	static private int mClassID = -1;
	static private final int
		E_NATIVECLASSCRASH = -1008,
		S_OK			= 0;
	static private final int
		NIS_GETINSTANCE		= 0x00000002; // get native pointer
	static private final int // enum tTJSNativeInstanceType
		nitMethod	= 1,
		nitProperty = 2;

	static private final String CLASS_NAME = "Timer";

	protected NativeInstance createNativeInstance() {
		return new TimerNI();
	}

	private static TimerNI getNativeInstance( Dispatch2 objthis ) {
		Holder<NativeInstance> holder = new Holder<NativeInstance>(null);
		int hr = objthis.nativeInstanceSupport( NIS_GETINSTANCE, mClassID, holder );
		if( hr < 0 ) return null;
		return (TimerNI) holder.mValue;
	}

	public TimerClass() throws VariantException, TJSException {
		super( CLASS_NAME );
		final int NCM_CLASSID = TJS.registerNativeClass(CLASS_NAME);
		setClassID( NCM_CLASSID );
		mClassID = NCM_CLASSID;

		// constructor
		registerNCM( CLASS_NAME, new NativeClassConstructor() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws VariantException, TJSException {
				TimerNI _this = (TimerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				int hr = _this.construct(param, objthis);
				if( hr < 0 ) return hr;
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "finalize", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) {
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		// event
		registerNCM( "onTimer", new NativeClassMethod() {
			@Override
			protected int process(Variant result, Variant[] param, Dispatch2 objthis) throws TJSException {
				TimerNI _this = (TimerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				VariantClosure obj = _this.getActionOwner();
				if( obj.mObject != null ) {
					String actionname = _this.getActionName();
					if( actionname.length() == 0 ) actionname = null;
					Dispatch2 evobj = EventManager.createEventObject( "onTimer", objthis, objthis );
					Variant[] pevval = new Variant[1];
					pevval[0] = new Variant(evobj, evobj);
					obj.funcCall( 0, actionname, result, pevval, null );
				}
				return S_OK;
			}
		}, CLASS_NAME, nitMethod, 0 );


		registerNCM( "interval", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				TimerNI _this = (TimerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				double interval = _this.getInterval() * (1.0 / (1<<TimerThread.SUBMILLI_FRAC_BITS));
				result.set( interval );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				TimerNI _this = (TimerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				double interval = param.asDouble() * (1<<TimerThread.SUBMILLI_FRAC_BITS);
				_this.setInterval((long)(interval + 0.5));
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "enabled", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				TimerNI _this = (TimerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getEnabled() ? 1 : 0 );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) {
				TimerNI _this = (TimerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setEnabled( param.asBoolean() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "capacity", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				TimerNI _this = (TimerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getCapacity() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				TimerNI _this = (TimerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setCapacity( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		registerNCM( "mode", new NativeClassProperty() {
			@Override public int get(Variant result, Dispatch2 objthis) {
				TimerNI _this = (TimerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				result.set( _this.getCapacity() );
				return S_OK;
			}
			@Override public int set(Variant param, Dispatch2 objthis) throws VariantException {
				TimerNI _this = (TimerNI)objthis.getNativeInstance(mClassID);
				if( _this == null ) return E_NATIVECLASSCRASH;
				_this.setCapacity( param.asInteger() );
				return S_OK;
			}
		}, CLASS_NAME, nitProperty, 0 );

		// オプション見てタイマースレッドの優先度を変える
		String prop = TVP.Properties.getProperty("laxtimer","no");
		if( "yes".equals(prop) ) {
			TimerNI.LimitTimerCapacity = true;
		}
	}
}
