package jp.kirikiri.tvp2.visual;

public interface LayerManagerInterface {


//-- draw device specific information
	/**
	 *  @brief	描画デバイス固有の情報を設定する
	 *  @param	data	描画デバイス固有の情報
	 *  @note	描画デバイス固有の情報をレイヤマネージャに設定する。
	 * 			レイヤマネージャではこの情報の中身については関知しない。
	 * 			描画デバイス側で目印に使ったり、特定の情報と結びつけて管理する。
	 */
	public void setDrawDeviceData(Object data);

	/**
	 *  @brief	描画デバイス固有の情報を取得する
	 *  @return	描画デバイス固有の情報
	 */
	public Object getDrawDeviceData();

//-- layer metrics
	/**
	 *  @brief	プライマリレイヤのサイズを取得する
	 *  @param	w	レイヤの横幅(ピクセル単位)
	 *  @param	h	レイヤの縦幅(ピクセル単位)
	 *  @return	取得に成功すれば真、失敗すれば偽
	 */
	//public boolean getPrimaryLayerSize(tjs_int &w, tjs_int &h);

//-- layer structure information
	/**
	 *  @brief	プライマリレイヤの取得
	 *  @return	プライマリレイヤ
	 */
	//public BaseLayerNI getPrimaryLayer();

	/**
	 *  @brief	フォーカスのあるレイヤの取得
	 *  @return	フォーカスのあるレイヤ
	 */
	//public BaseLayerNI getFocusedLayer();

	/**
	 *  @brief	フォーカスのあるレイヤの設定
	 *  @param	layer	フォーカスのあるレイヤ
	 */
	//public void SetFocusedLayer( BaseLayerNI layer );

//-- HID releted
	/**
	 *  @brief		クリックされた
	 *  @param		x		プライマリレイヤ座標上における x 位置
	 *  @param		y		プライマリレイヤ座標上における y 位置
	 */
	public void notifyClick( int x, int y );

	/**
	 *  @brief		ダブルクリックされた
	 *  @param		x		プライマリレイヤ座標上における x 位置
	 *  @param		y		プライマリレイヤ座標上における y 位置
	 */
	public void notifyDoubleClick( int x, int y );

	/**
	 *  @brief		マウスボタンが押下された
	 *  @param		x		プライマリレイヤ座標上における x 位置
	 *  @param		y		プライマリレイヤ座標上における y 位置
	 *  @param		mb		どのマウスボタンか
	 *  @param		flags	フラグ(TVP_SS_*定数の組み合わせ)
	 */
	public void notifyMouseDown( int x, int y, int mb, int flags );

	/**
	 *  @brief		マウスボタンが離された
	 *  @param		x		プライマリレイヤ座標上における x 位置
	 *  @param		y		プライマリレイヤ座標上における y 位置
	 *  @param		mb		どのマウスボタンか
	 *  @param		flags	フラグ(TVP_SS_*定数の組み合わせ)
	 */
	public void notifyMouseUp( int x, int y, int mb, int flags );

	/**
	 *  @brief		マウスが移動した
	 *  @param		x		プライマリレイヤ座標上における x 位置
	 *  @param		y		プライマリレイヤ座標上における y 位置
	 *  @param		flags	フラグ(TVP_SS_*定数の組み合わせ)
	 */
	public void notifyMouseMove( int x, int y, int flags );

	/**
	 *  @brief		マウスキャプチャを解放する
	 *  @note		マウスキャプチャを解放すべき場合にウィンドウから呼ばれる。
	 */
	public void releaseCapture();

	/**
	 *  @brief		マウスがプライマリレイヤ外に移動した
	 */
	public void notifyMouseOutOfWindow();

	/**
	 *  @brief		キーが押された
	 *  @param		key		仮想キーコード
	 *  @param		shift	シフトキーの状態
	 */
	public void notifyKeyDown( int key, int shift );

	/**
	 *  @brief		キーが離された
	 *  @param		key		仮想キーコード
	 *  @param		shift	シフトキーの状態
	 */
	public void notifyKeyUp( int key, int shift );

	/**
	 *  @brief		キーによる入力
	 *  @param		key		文字コード
	 */
	public void notifyKeyPress( char key );

	/**
	 *  @brief		マウスホイールが回転した
	 *  @param		shift	シフトキーの状態
	 *  @param		delta	回転角
	 *  @param		x		プライマリレイヤ座標上における x 位置
	 *  @param		y		プライマリレイヤ座標上における y 位置
	 */
	public void notifyMouseWheel( int shift, int delta, int x, int y );

	/**
	 *  @brief		入力状態のチェック
	 *  @note		ウィンドウから約1秒おきに、レイヤマネージャがユーザからの入力の状態を
	 * 				再チェックするために呼ばれる。レイヤ状態の変化がユーザの入力とは
	 * 				非同期に行われた場合、たとえばマウスカーソルの下にレイヤが出現した
	 * 				のにもかかわらず、マウスカーソルがそのレイヤの指定する形状に変更されない
	 * 				といった状況が発生しうる。このような状況に対処するため、ウィンドウから
	 * 				このメソッドが約1秒おきに呼ばれる。
	 */
	public void recheckInputState();

//-- invalidation/update
	/**
	 *  @brief		描画デバイスが望むレイヤの出力形式を設定する
	 *  @param		type	レイヤ形式
	 *  @note		デフォルトは ltOpaque 。描画デバイスが他の形式の画像を出力として
	 * 				望むならばその形式を指定する。ただし、プライマリレイヤの type
	 * 				プロパティも同様に変更すること。
	 */
	public void setDesiredLayerType( int type );

	/**
	 *  @brief		特定の矩形の再描画を要求する
	 *  @param		r		プライマリレイヤ座標上における矩形
	 *  @note		特定の矩形の再描画をレイヤマネージャに対して要求する。
	 * 				要求は記録されるだけでこのメソッドはすぐに戻る。実際にそれが
	 * 				演算されるのは UpdateToDrawDevice() を呼んだときである。
	 */
	//public void requestInvalidation( final Rect r ); // draw device -> layer

	/**
	 *  @brief		内容の再描画を行う
	 *  @note		内容の再描画を行う際に呼ぶ。このメソッド内では、レイヤマネージャは
	 * 				iTVPDrawDevice::StartBitmapCompletion()
	 * 				iTVPDrawDevice::NotifyBitmapCompleted()
	 * 				iTVPDrawDevice::EndBitmapCompletion() の各メソッドを用い、
	 * 				いままでに変更が行われた領域などを順次描画デバイスに送る。
	 */
	public void updateToDrawDevice();

//-- debug assist
	/**
	 *  @brief		(Window->DrawDevice) レイヤ構造をコンソールにダンプする
	 */
	public void dumpLayerStructure();
}
